%global need_bootstrap_set 0

%{!?need_bootstrap: %global need_bootstrap %{need_bootstrap_set}}

%ifarch %{arm} %{ix86} x86_64 ppc %{power64}
%global __with_hipe 1
%endif

##
## Optional components
##


# Changes done for AIX:
# emacs : 0
# Java  : 0
# Doc   : 0
# WxWidget: 0
%global __with_emacs 0
%global __with_examples 1
%global __with_java 0
%global __with_tcltk 1

%global withdoc 0
%global __with_wxwidgets 0

#
# wxWidgets plugin blocks the following ones:
#
# * debugger - https://bugzilla.redhat.com/1095715
# * dialyzer - https://bugzilla.redhat.com/1095717
# * et - https://bugzilla.redhat.com/1095718
# * observer - https://bugzilla.redhat.com/1095721
# * reltool - https://bugzilla.redhat.com/1095727
#
# debugger blocks:
#
# * common_test
# * megaco
#
# dialyzer blocks:
#
# * typer
#
# et blocks:
#
# * megaco
#
# observer blocks:
#
# * common_test
#
# So finally we have to disable the following plugins:
#
# common_test
# debugger
# dialyzer
# et
# megaco
# observer
# reltool (*)
# typer
# wx
#


Name:		erlang
Version:	19.2
Release:	2%{?dist}
Summary:	General-purpose programming language and runtime environment

Group:		Development/Languages
License:	ASL 2.0
URL:		http://www.erlang.org
%if 0%{?el7}%{?fedora}
VCS:		scm:git:https://github.com/erlang/otp
%endif
Source0:	https://github.com/erlang/otp/archive/OTP-%{version}/otp_src_%{version}.tar.gz
Source5:	epmd.service
Source6:	epmd.socket
Source7:	epmd@.service
Source8:	epmd@.socket
# scripts to test after building
Source997:	erlang-19.2-2.lance_reste_tests.ksh
# These files are intended for Fedora package maintainers only.
Source998:	otp-make-subpackages.py
Source999:	otp-get-patches.sh

# For the source of the Fedora specific patches, see the respective
# branch at https://github.com/lemenkov/otp
#
# Run something like
#    $ git clone git://github.com/erlang/otp.git
#    $ cd otp
#    $ git remote add fedora https://git.fedorahosted.org/git/erlang.git
#    $ git fetch -v --all
# to get yourself a copy of the Erlang/OTP source code with the
# Fedora specific patches from Fedora. Then run something like
#    $ ./otp-get-patches.sh /path/to/otp OTP_R14B02 fedora/fedora-R14B02
# for some semi-automatic patch update assistance.
#
# start of autogenerated patch tag list
# Fedora specific patch
#   Do not format man-pages and do not install miscellaneous
Patch1: otp-0001-Do-not-format-man-pages-and-do-not-install-miscellan.patch
# Fedora specific patch
#   Remove rpath
Patch2: otp-0002-Remove-rpath.patch
# Fedora specific patch
#   Do not install C sources
Patch3: otp-0003-Do-not-install-C-sources.patch
# Fedora specific patch
#   Do not install Java sources
Patch4: otp-0004-Do-not-install-Java-sources.patch
# Fedora specific patch
#   Do not install nteventlog and related doc-files on non-win32
Patch5: otp-0005-Do-not-install-nteventlog-and-related-doc-files-on-n.patch
# Fedora specific patch
#   Do not install erlang sources
Patch6: otp-0006-Do-not-install-erlang-sources.patch

# Fedora specific patch
#   erts: Fix correct link flags for hipe_mkliterals
# Already applied on 19.2 ??
#Patch7: otp-0007-erts-Fix-correct-link-flags-for-hipe_mkliterals.patch
# Fedora specific patch
#   erts: Disable -fPIE for HiPE on x86_64
# Already applied on 19.2 ??
#Patch8: otp-0008-erts-Disable-fPIE-for-HiPE-on-x86_64.patch
# end of autogenerated patch tag list


# AIX patches
Patch10: erlang-19.2-1_AIX_AssemblerLabel.patch
Patch11: erlang-19.2-1_AIX_utils_mallopt.patch
Patch12: erlang-19.2-1_AIX_reqevents.patch
Patch13: erlang-19.2-1_AIX_hipe_ppc.patch
Patch14: erlang-19.2-1_AIX_hipe_ppc_bifs.patch
Patch15: erlang-19.2-1_AIX_MSG_DONTWAIT.patch
Patch16: erlang-19.2-1_AIX_run_erl.patch
Patch17: erlang-19.2-1_AIX_aix_configure.in.patch
Patch18: erlang-19.2-1_AIX_Makefile.in.ld64bit.patch
Patch19: erlang-19.2-1_AIX_Makefile.in.Wl.patch
# 20: To be finalized ; applied once release directory is built
Patch20: erlang-19.2-1_AIX_DynamicTestConfigure.patch
Patch21: erlang-19.2-1_AIX_unsupported_os.patch
Patch22: erlang-19.2-1_AIX_unix_aix.patch

# config.guess pach for aix : return  powerpc-ibm-aix6.1 in place of powerpc-ibm-aix6.1.9.0
Patch23: erlang-19.2-1_AIX_config.guess.patch

BuildRequires:	flex

%define need_bootstrap 0

%if %{withdoc}
# Syntax issue
#%if 0%{?need_bootstrap} < 1
## Required for building docs (escript)
#BuildRequires:	erlang
#%endif
%endif

%if 0%{?el7}%{?fedora}
# for <systemd/sd-daemon.h>
BuildRequires:	systemd-devel
BuildRequires:	systemd
Requires(post):	systemd
Requires(preun):systemd
Requires(postun):systemd
Requires:	systemd
%endif
BuildRequires:	autoconf
BuildRequires:	automake
#BuildRequires:	erlang-rpm-macros

Requires: %{name}-asn1%{?_isa} = %{version}-%{release}
%if %{__with_wxwidgets}
Requires: %{name}-common_test%{?_isa} = %{version}-%{release}
%endif %{__with_wxwidgets}
Requires: %{name}-compiler%{?_isa} = %{version}-%{release}
Requires: %{name}-cosEvent%{?_isa} = %{version}-%{release}
Requires: %{name}-cosEventDomain%{?_isa} = %{version}-%{release}
Requires: %{name}-cosFileTransfer%{?_isa} = %{version}-%{release}
Requires: %{name}-cosNotification%{?_isa} = %{version}-%{release}
Requires: %{name}-cosProperty%{?_isa} = %{version}-%{release}
Requires: %{name}-cosTime%{?_isa} = %{version}-%{release}
Requires: %{name}-cosTransactions%{?_isa} = %{version}-%{release}
Requires: %{name}-crypto%{?_isa} = %{version}-%{release}
%if %{__with_wxwidgets}
Requires: %{name}-debugger%{?_isa} = %{version}-%{release}
%endif %{__with_wxwidgets}
%if %{__with_wxwidgets}
Requires: %{name}-dialyzer%{?_isa} = %{version}-%{release}
%endif %{__with_wxwidgets}
Requires: %{name}-diameter%{?_isa} = %{version}-%{release}
Requires: %{name}-edoc%{?_isa} = %{version}-%{release}
Requires: %{name}-eldap%{?_isa} = %{version}-%{release}
Requires: %{name}-erl_docgen%{?_isa} = %{version}-%{release}
Requires: %{name}-erl_interface%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
%if %{__with_wxwidgets}
Requires: %{name}-et%{?_isa} = %{version}-%{release}
%endif %{__with_wxwidgets}
Requires: %{name}-eunit%{?_isa} = %{version}-%{release}
%if %{__with_tcltk}
Requires: %{name}-gs%{?_isa} = %{version}-%{release}
%endif %{__with_tcltk}
Requires: %{name}-hipe%{?_isa} = %{version}-%{release}
%if %{__with_java}
Requires: %{name}-ic%{?_isa} = %{version}-%{release}
%endif %{__with_java}
Requires: %{name}-inets%{?_isa} = %{version}-%{release}
%if %{__with_java}
Requires: %{name}-jinterface%{?_isa} = %{version}-%{release}
%endif %{__with_java}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
%if %{__with_wxwidgets}
Requires: %{name}-megaco%{?_isa} = %{version}-%{release}
%endif %{__with_wxwidgets}
Requires: %{name}-mnesia%{?_isa} = %{version}-%{release}
%if %{__with_wxwidgets}
Requires: %{name}-observer%{?_isa} = %{version}-%{release}
%endif %{__with_wxwidgets}
Requires: %{name}-odbc%{?_isa} = %{version}-%{release}
Requires: %{name}-orber%{?_isa} = %{version}-%{release}
Requires: %{name}-os_mon%{?_isa} = %{version}-%{release}
Requires: %{name}-otp_mibs%{?_isa} = %{version}-%{release}
Requires: %{name}-parsetools%{?_isa} = %{version}-%{release}
Requires: %{name}-percept%{?_isa} = %{version}-%{release}
Requires: %{name}-public_key%{?_isa} = %{version}-%{release}
%if %{__with_wxwidgets}
Requires: %{name}-reltool%{?_isa} = %{version}-%{release}
%endif %{__with_wxwidgets}
Requires: %{name}-runtime_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-sasl%{?_isa} = %{version}-%{release}
Requires: %{name}-snmp%{?_isa} = %{version}-%{release}
Requires: %{name}-ssh%{?_isa} = %{version}-%{release}
Requires: %{name}-ssl%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-syntax_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-tools%{?_isa} = %{version}-%{release}
%if %{__with_wxwidgets}
Requires: %{name}-typer%{?_isa} = %{version}-%{release}
%endif %{__with_wxwidgets}
%if %{__with_wxwidgets}
Requires: %{name}-wx%{?_isa} = %{version}-%{release}
%endif %{__with_wxwidgets}
Requires: %{name}-xmerl%{?_isa} = %{version}-%{release}

%description
Erlang is a general-purpose programming language and runtime
environment. Erlang has built-in support for concurrency, distribution
and fault tolerance. Erlang is used in several large telecommunication
systems from Ericsson.

### BEGIN OF AUTOGENERATED LIST ###

%package asn1
Summary: Provides support for Abstract Syntax Notation One
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description asn1
Provides support for Abstract Syntax Notation One.

%if %{__with_wxwidgets}
%package common_test
Summary: A portable framework for automatic testing
Group: Development/Languages
Requires: %{name}-compiler%{?_isa} = %{version}-%{release}
Requires: %{name}-crypto%{?_isa} = %{version}-%{release}
Requires: %{name}-debugger%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-inets%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-observer%{?_isa} = %{version}-%{release}
Requires: %{name}-runtime_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-sasl%{?_isa} = %{version}-%{release}
Requires: %{name}-snmp%{?_isa} = %{version}-%{release}
Requires: %{name}-ssh%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-syntax_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-tools%{?_isa} = %{version}-%{release}
Requires: %{name}-xmerl%{?_isa} = %{version}-%{release}
Obsoletes: erlang-test_server

%description common_test
A portable framework for automatic testing.
%endif %{__with_wxwidgets}

%package compiler
Summary: A byte code compiler for Erlang which produces highly compact code
Group: Development/Languages
Requires: %{name}-crypto%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-hipe%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description compiler
A byte code compiler for Erlang which produces highly compact code.

%package cosEvent
Summary: Orber OMG Event Service
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-orber%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description cosEvent
Orber OMG Event Service.

%package cosEventDomain
Summary: Orber OMG Event Domain Service
Group: Development/Languages
Requires: %{name}-cosNotification%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-orber%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description cosEventDomain
Orber OMG Event Domain Service.

%package cosFileTransfer
Summary: Orber OMG File Transfer Service
Group: Development/Languages
Requires: %{name}-cosProperty%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-inets%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-orber%{?_isa} = %{version}-%{release}
Requires: %{name}-ssl%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description cosFileTransfer
Orber OMG File Transfer Service.

%package cosNotification
Summary: Orber OMG Notification Service
Group: Development/Languages
Requires: %{name}-cosEvent%{?_isa} = %{version}-%{release}
Requires: %{name}-cosTime%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-orber%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description cosNotification
Orber OMG Notification Service.

%package cosProperty
Summary: Orber OMG Property Service
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-mnesia%{?_isa} = %{version}-%{release}
Requires: %{name}-orber%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description cosProperty
Orber OMG Property Service.

%package cosTime
Summary: Orber OMG Timer and TimerEvent Service
Group: Development/Languages
Requires: %{name}-cosEvent%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-orber%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description cosTime
Orber OMG Timer and TimerEvent Service.

%package cosTransactions
Summary: Orber OMG Transaction Service
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-orber%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description cosTransactions
Orber OMG Transaction Service.

%package crypto
Summary: Cryptographical support
Group: Development/Languages
BuildRequires: openssl-devel
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description crypto
Cryptographical support.

%if %{__with_wxwidgets}
%package debugger
Summary: A debugger for debugging and testing of Erlang programs
Group: Development/Languages
Requires: %{name}-compiler%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-wx%{?_isa} = %{version}-%{release}

%description debugger
A debugger for debugging and testing of Erlang programs.
%endif %{__with_wxwidgets}

%if %{__with_wxwidgets}
%package dialyzer
Summary: A DIscrepancy AnaLYZer for ERlang programs
Group: Development/Languages
Requires: %{name}-compiler%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-hipe%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-syntax_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-wx%{?_isa} = %{version}-%{release}
Requires: graphviz

%description dialyzer
A DIscrepancy AnaLYZer for ERlang programs.
%endif %{__with_wxwidgets}

%package diameter
Summary: Diameter (RFC 3588) library
Group: Development/Languages

# Provided by AIX. Same features ?
#BuildRequires: ed
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-runtime_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-ssl%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-syntax_tools%{?_isa} = %{version}-%{release}

%description diameter
Diameter (RFC 3588) library

%if %{withdoc}
%package doc
Summary: Erlang documentation
Group: Development/Languages
BuildRequires: fop
BuildRequires: libxslt
BuildArch: noarch

%description doc
Documentation for Erlang.
%endif

%package edoc
Summary: A utility used to generate documentation out of tags in source files
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-inets%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-syntax_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-xmerl%{?_isa} = %{version}-%{release}

%description edoc
A utility used to generate documentation out of tags in source files.

%package eldap
Summary: Erlang LDAP library
Group: Development/Languages
Requires: %{name}-asn1%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-ssl%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description eldap
Erlang LDAP library.

%package erl_docgen
Summary: A utility used to generate erlang HTML documentation
Group: Development/Languages
Requires: %{name}-edoc%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-xmerl%{?_isa} = %{version}-%{release}

%description erl_docgen
A utility used to generate erlang HTML documentation.

%package erl_interface
Summary: Low level interface to C
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}

%description erl_interface
Low level interface to C.

%package erts
Summary: Functionality necessary to run the Erlang System itself
Group: Development/Languages
# echo "BuildRequires: lksctp-tools-devel" removed
#BuildRequires: lksctp-tools-devel
BuildRequires: m4
BuildRequires: ncurses-devel
BuildRequires: zlib-devel
# epmd user, epmd group
#Requires(pre): shadow-utils
Requires: shadow-utils
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: lksctp-tools
# See erts/emulator/beam/erl_driver.h or call erlang:system_info(driver_version).
#Provides: erlang(erl_drv_version) = %%(%%{buildroot}/bin/erl -noshell -eval 'io:format(erlang:system_info(driver_version)).' -s erlang halt)
Provides: erlang(erl_drv_version) = 3.3
# See erts/emulator/beam/erl_nif.h or call erlang:system_info(nif_version).
#Provides: erlang(erl_nif_version) = %%(%%{buildroot}/bin/erl -noshell -eval 'io:format(erlang:system_info(nif_version)).' -s erlang halt)
Provides: erlang(erl_nif_version) = 2.11
Provides: bundled(pcre) = 8.33
Obsoletes: erlang-appmon
Obsoletes: erlang-docbuilder
Obsoletes: erlang-inviso
Obsoletes: erlang-ose
Obsoletes: erlang-pman
Obsoletes: erlang-toolbar
Obsoletes: erlang-tv
Obsoletes: erlang-webtool

%description erts
Functionality necessary to run the Erlang System itself.

%if %{__with_wxwidgets}
%package et
Summary: An event tracer for Erlang programs
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-runtime_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-wx%{?_isa} = %{version}-%{release}

%description et
An event tracer for Erlang programs.
%endif %{__with_wxwidgets}

%package eunit
Summary: Support for unit testing
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description eunit
Support for unit testing.

%if %{__with_examples}
%package examples
Summary: Examples for some Erlang modules
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
%if %{__with_tcltk}
Requires: %{name}-gs%{?_isa} = %{version}-%{release}
%endif %{__with_tcltk}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-public_key%{?_isa} = %{version}-%{release}
Requires: %{name}-sasl%{?_isa} = %{version}-%{release}
Requires: %{name}-ssl%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description examples
Examples for some Erlang modules.
%endif %{__with_examples}

%if %{__with_tcltk}
%package gs
Summary: A library for Tcl/Tk support in Erlang
Group: Development/Languages
BuildRequires: tcl-devel
BuildRequires: tk-devel
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: tk

%description gs
A Graphics System used to write platform independent user interfaces.
%endif %{__with_tcltk}

%package hipe
Summary: High Performance Erlang
Group: Development/Languages
Requires: %{name}-compiler%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-syntax_tools%{?_isa} = %{version}-%{release}

%description hipe
High Performance Erlang.

%package ic
Summary: IDL compiler
Group: Development/Languages
%if %{__with_java}
BuildRequires: java-devel
%endif %{__with_java}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description ic
IDL compiler.

%package inets
Summary: A set of services such as a Web server and a ftp client etc
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-mnesia%{?_isa} = %{version}-%{release}
Requires: %{name}-runtime_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-ssl%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description inets
A set of services such as a Web server and a ftp client etc.

%if %{__with_java}
%package jinterface
Summary: A library for accessing Java from Erlang
Group: Development/Languages
BuildRequires: java-devel
Requires: %{name}-erts%{?_isa} = %{version}-%{release}

%description jinterface
Low level interface to Java.
%endif %{__with_java}

%package kernel
Summary: Main erlang library
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description kernel
Main erlang library.

%if %{__with_wxwidgets}
%package megaco
Summary: Megaco/H.248 support library
Group: Development/Languages
Requires: %{name}-asn1%{?_isa} = %{version}-%{release}
Requires: %{name}-debugger%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-et%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-runtime_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description megaco
Megaco/H.248 is a protocol for control of elements in a physically
decomposed multimedia gateway, enabling separation of call control
from media conversion.
%endif %{__with_wxwidgets}

%package mnesia
Summary: A heavy duty real-time distributed database
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description mnesia
A heavy duty real-time distributed database.

%if %{__with_wxwidgets}
%package observer
Summary: A set of tools for tracing and investigation of distributed systems
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-et%{?_isa} = %{version}-%{release}
Requires: %{name}-inets%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-runtime_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-wx%{?_isa} = %{version}-%{release}

%description observer
A set of tools for tracing and investigation of distributed systems.
%endif %{__with_wxwidgets}

%package odbc
Summary: A library for unixODBC support in Erlang
Group: Development/Languages
BuildRequires: unixODBC-devel
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description odbc
An interface to relational SQL-databases built on ODBC (Open Database
Connectivity).

%package orber
Summary: A CORBA Object Request Broker
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-inets%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-mnesia%{?_isa} = %{version}-%{release}
Requires: %{name}-ssl%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description orber
A CORBA Object Request Broker.

%package os_mon
Summary: A monitor which allows inspection of the underlying operating system
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-mnesia%{?_isa} = %{version}-%{release}
Requires: %{name}-otp_mibs%{?_isa} = %{version}-%{release}
Requires: %{name}-sasl%{?_isa} = %{version}-%{release}
Requires: %{name}-snmp%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description os_mon
A monitor which allows inspection of the underlying operating system.

%package otp_mibs
Summary: SNMP management information base for Erlang/OTP nodes
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-mnesia%{?_isa} = %{version}-%{release}
Requires: %{name}-snmp%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description otp_mibs
SNMP management information base for Erlang/OTP nodes.

%package parsetools
Summary: A set of parsing and lexical analysis tools
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description parsetools
A set of parsing and lexical analysis tools.

%package percept
Summary: A concurrency profiler tool
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-inets%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-runtime_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description percept
A concurrency profiler tool.

%package public_key
Summary: API to public key infrastructure
Group: Development/Languages
Requires: %{name}-asn1%{?_isa} = %{version}-%{release}
Requires: %{name}-crypto%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description public_key
API to public key infrastructure.

%if %{__with_wxwidgets}
%package reltool
Summary: A release management tool
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-sasl%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-tools%{?_isa} = %{version}-%{release}
Requires: %{name}-wx%{?_isa} = %{version}-%{release}

%description reltool
Reltool is a release management tool. It analyses a given
Erlang/OTP installation and determines various dependencies
between applications. The graphical frontend depicts the
dependencies and enables interactive customization of a
target system. The backend provides a batch interface
for generation of customized target systems.
%endif %{__with_wxwidgets}

%package runtime_tools
Summary: A set of tools to include in a production system
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-mnesia%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description runtime_tools
A set of tools to include in a production system.

%package sasl
Summary: The System Architecture Support Libraries
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: %{name}-tools%{?_isa} = %{version}-%{release}

%description sasl
The System Architecture Support Libraries is a set of tools for
release upgrades and alarm handling etc.

%package snmp
Summary: Simple Network Management Protocol (SNMP) support
Group: Development/Languages
Requires: %{name}-crypto%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-mnesia%{?_isa} = %{version}-%{release}
Requires: %{name}-runtime_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description snmp
Simple Network Management Protocol (SNMP) support including a
MIB compiler and tools for creating SNMP agents.

%package ssh
Summary: Secure Shell application with sftp and ssh support
Group: Development/Languages
Requires: %{name}-crypto%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-public_key%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description ssh
Secure Shell application with sftp and ssh support.

%package ssl
Summary: Secure Socket Layer support
Group: Development/Languages
Requires: %{name}-crypto%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-inets%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-public_key%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description ssl
Secure Socket Layer support.

%package stdlib
Summary: The Erlang standard libraries
Group: Development/Languages
Requires: %{name}-compiler%{?_isa} = %{version}-%{release}
Requires: %{name}-crypto%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}

%description stdlib
The Erlang standard libraries.

%package syntax_tools
Summary: A set of tools for dealing with erlang sources
Group: Development/Languages
Requires: %{name}-compiler%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description syntax_tools
A utility used to handle abstract Erlang syntax trees,
reading source files differently, pretty-printing syntax trees.

%package tools
Summary: A set of programming tools including a coverage analyzer etc
Group: Development/Languages
%if %{__with_emacs}
BuildRequires: emacs
BuildRequires: emacs-el
BuildRequires: xemacs
BuildRequires: xemacs-packages-extra-el
%endif %{__with_emacs}
Requires: %{name}-compiler%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-inets%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-runtime_tools%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
%if %{__with_emacs}
Requires: emacs-filesystem
Requires: xemacs-filesystem
Obsoletes: emacs-erlang
Obsoletes: emacs-erlang-el
Obsoletes: xemacs-erlang
Obsoletes: xemacs-erlang-el
%endif %{__with_emacs}


%description tools
A set of programming tools including a coverage analyzer etc.

%if %{__with_wxwidgets}
%package typer
Summary: TYPe annotator for ERlang programs
Group: Development/Languages
Requires: %{name}-compiler%{?_isa} = %{version}-%{release}
Requires: %{name}-dialyzer%{?_isa} = %{version}-%{release}
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-hipe%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description typer
TYPe annotator for ERlang programs.
%endif %{__with_wxwidgets}

%if %{__with_wxwidgets}
%package wx
Summary: A library for wxWidgets support in Erlang
Group: Development/Languages
BuildRequires: wxGTK3-devel
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
Requires: mesa-libGL
Requires: mesa-libGLU

%description wx
A Graphics System used to write platform independent user interfaces.
%endif %{__with_wxwidgets}

%package xmerl
Summary: Provides support for XML 1.0
Group: Development/Languages
Requires: %{name}-erts%{?_isa} = %{version}-%{release}
Requires: %{name}-kernel%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}

%description xmerl
Provides support for XML 1.0.

### END OF AUTOGENERATED LIST ###

%prep
export LIBPATH="/opt/freeware/lib"
export PATH=$PWD/bin:/usr/local/bin/:/opt/freeware/bin:/usr/linux/bin:/usr/local/bin:/usr/bin:/etc:/usr/sbin:/usr/ucb:/usr/bin/X11:/sbin:/usr/java8_64/jre/bin:/usr/java8_64/bin

%setup -q -n otp_src_%{version}

# start of autogenerated prep patch list
%patch1 -p1 -b .Do_not_format_man_pages_and_do_not_install_miscellan
%patch2 -p1 -b .Remove_rpath
%patch3 -p1 -b .Do_not_install_C_sources
%patch4 -p1 -b .Do_not_install_Java_sources
%patch5 -p1 -b .Do_not_install_nteventlog_and_related_doc_files_on_n
%patch6 -p1 -b .Do_not_install_erlang_sources
#%patch7 -p1 -b .erts_Fix_correct_link_flags_for_hipe_mkliterals
#%patch8 -p1 -b .erts_Disable_fPIE_for_HiPE_on_x86_64
# end of autogenerated prep patch list

# AIX patch for AssemblerLabels
%patch10 -p1 -b .AIX_AssemblerLabel
%patch11 -p1 -b .AIX_utils_mallopt
%patch12 -p1 -b .AIX_reqevents
%patch13 -p1 -b .AIX_hipe_ppc
%patch14 -p1 -b .AIX_hipe_ppc_bifs
%patch15 -p1 -b .AIX_MSG_DONTWAIT
%patch16 -p1 -b .AIX_run_erl
%patch17 -p1 -b .AIX_aix_configure.in
%patch18 -p1 -b .AIX_Makefile.in.ld64bit
%patch19 -p1 -b .AIX_Makefile.in.Wl
%patch21 -p1 -b .AIX_unsupported_os
%patch22 -p1 -b .AIX_unix_aix
%patch23 -p1

# FIXME we should come up with a better solution
# remove shipped zlib sources
#rm -f erts/emulator/zlib/*.[ch]

# Reconfigure everything to apply changes to the autotools templates
./otp_build autoconf


%build

unset ERL_TOP
export RM="/usr/bin/rm -f"
export AR="/usr/bin/ar"
export NM="/usr/bin/nm -X32_64"

export CC="/opt/freeware/bin/gcc"
export CXX="/opt/freeware/bin/g++"
export LDFLAGS="-L/opt/freeware/lib"
export FLAGS="-maix32"
export PATH=$PWD/bin:/usr/local/bin/:/opt/freeware/bin:/usr/linux/bin:/usr/local/bin:/usr/bin:/etc:/usr/sbin:/usr/ucb:/usr/bin/X11:/sbin:/usr/java8_64/jre/bin:/usr/java8_64/bin

export LIBPATH="/opt/freeware/lib"
export MAKE="opt/freeware/bin/make -k"
echo "CC Version:"
$CC --version


# Set up proper cflags/cxxflags first
%ifarch sparcv9 sparc64
ERL_FLAGS="${RPM_OPT_FLAGS} -mcpu=ultrasparc -fno-strict-aliasing"
%else
ERL_FLAGS="${RPM_OPT_FLAGS} -fno-strict-aliasing -D_LINUX_SOURCE_COMPAT"
%endif

echo "-maix64 & -maix32"

# Several --disable instead of:
#	%{?__with_hipe:--enable-hipe} \
# Some more options (See: HOWTO/INSTALL.md) :
#	--enable-m64-build`			- Build 64-bit binaries using the `-m64` flag to `(g)cc`
#	--enable-m32-build` 			- Build 32-bit binaries using the `-m32` flag to `(g)cc`
#	--{enable,disable}-dynamic-ssl-lib` 	- Dynamic OpenSSL libraries
#	--{enable,disable}-builtin-zlib` 	- Use the built-in source for zlib.
#	--{with,without}-ssl` 			- OpenSSL (without implies that the `crypto`, `ssh`, and `ssl` won't be built)
#	--with-ssl=PATH` 			- Specify location of OpenSSL include and lib
#	--with-ssl-incl=PATH` 			- Location of OpenSSL `include` directory, if different than specified by `--with-ssl=PATH`
#	--with-libatomic_ops=PATH`		- Use the `libatomic_ops` library for atomic memory accesses.
#							If `configure` should inform you about no native atomic
#							implementation available, you typically want to try using the
#							`libatomic_ops` library.

# --disable-hipe --disable-threads --disable-smp-support


CFLAGS="${ERL_FLAGS} -maix32" CXXFLAGS="${ERL_FLAGS} -maix32" %configure --enable-shared-zlib --enable-sctp --disable-systemd \
	--disable-hipe --disable-threads \
	--disable-smp-support \
	--without-javac \
%if %{__with_java}
	\
%else
	--without-jinterface \
%endif %{__with_java}
%if %{__with_tcltk}
	\
%else
	--without-gs \
%endif %{__with_tcltk}
%if %{__with_wxwidgets}
	--with-wx-config=/usr/bin/wx-config-3.0
%else
	--without-common_test \
	--without-debugger \
	--without-dialyzer \
	--without-et \
	--without-megaco \
	--without-observer \
	--without-reltool \
	--without-typer \
	--without-wx
%endif %{__with_wxwidgets}

# Remove pre-built BEAM files
gmake clean


nb=0;
find . -name 'powerpc-ibm-aix6.1' |
    while read dir;
    do
	[ -L $dir.9.0 ] && continue;
	bn=$(basename $dir);
	ln -s $(basename $dir) $dir.9.0
	let nb=$nb+1;
    done
echo nombre de liens crs : $nb


%if %{__with_emacs}
# GNU Emacs/XEmacs related stuff
erlang_tools_vsn="$(sed -n 's/TOOLS_VSN = //p' lib/tools/vsn.mk)"

# GNU Emacs related stuff
cat > emacs-erlang-init.el << EOF
(setq load-path (cons "%{_emacs_sitelispdir}/erlang" load-path))
(setq erlang-root-dir "%{_libdir}/erlang")
(setq exec-path (cons "%{_libdir}/erlang/bin" exec-path))
(require 'erlang-start)
EOF
mkdir emacs-erlang
cp lib/tools/emacs/*.el emacs-erlang/
pushd emacs-erlang
%{_emacs_bytecompile} *.el
popd

# XEmacs related stuff
cat > xemacs-erlang-init.el << EOF
(setq load-path (cons "%{_xemacs_sitelispdir}/erlang" load-path))
(setq erlang-root-dir "%{_libdir}/erlang")
(setq exec-path (cons "%{_libdir}/erlang/bin" exec-path))
(require 'erlang-start)
EOF
mkdir xemacs-erlang
cp lib/tools/emacs/*.el xemacs-erlang/
rm -f xemacs-erlang/erlang-flymake.el xemacs-erlang/erlang-test.el
pushd xemacs-erlang
%{_xemacs_bytecompile} *.el
popd
%endif %{__with_emacs}


# Build #############################""""

export ERL_TOP=.

unset AIX64
unset AIX32
AIX32=true gmake

%if %{withdoc}
# should use FOP_OPTS after #832323 is resolved
%ifnarch ppc %{power64}
export BASE_OPTIONS=-Xmx1024m
%else
export BASE_OPTIONS=-Xmx1536m
%endif
gmake docs
%endif


nb=0;
find . -name 'powerpc-ibm-aix6.1' |
    while read dir;
    do
	[ -L $dir.9.0 ] && continue;
	bn=$(basename $dir);
	ln -s $(basename $dir) $dir.9.0
	let nb=$nb+1;
    done
echo nombre de liens crs : $nb


# Add 3 links necessary for tests
# 
cd ./erts/emulator/beam
ln -s  $ERL_TOP/erts/include/erl_fixed_size_int_types.h     erl_fixed_size_int_types.h
ln -s  $ERL_TOP/erts/include/erl_memory_trace_parser.h      erl_memory_trace_parser.h 
ln -s  $ERL_TOP/erts/include/powerpc-ibm-aix6.1/erl_int_sizes_config.h  erl_int_sizes_config.h
cd -

Tests #############################""""

export ERL_TOP=`pwd`

gmake release_tests

patch -p1 -b --suffix .AIX_DynamicTestConfigure -s < /opt/freeware/src/packages/SOURCES/erlang-19.2-1_AIX_DynamicTestConfigure.patch

# Smoke tests
# We must understand why conf_vars.in is missing...
cp ./lib/common_test/test_server/conf_vars.in release/tests/test_server
cd release/tests/test_server
$ERL_TOP/bin/erl -s ts install -s ts smoke_test batch -s init stop
#	Testing tests.emulator_test.smoke_test_SUITE: Starting test, 3 test cases
#	Testing tests.emulator_test.smoke_test_SUITE: TEST COMPLETE, 3 ok, 0 failed of 3 test cases
# Look at: $ERL_TOP/release/tests/test_server/index.html
#	grep COMPLETE, $SPECS/erlang-... | grep failed | awk '{print $8}'

cd $ERL_TOP
gmake tests

export TESTROOT=$ERL_TOP/release/tests/


# One test
# cd $TESTROOT/test_server
### $ERL_TOP/bin/ct_run -pa $TESTROOT/test_server -suite ../compiler_test/andor_SUITE -case t_orelse

echo "ALL TESTS"
# All tests
### $ERL_TOP/bin/erl -pa $TESTROOT/test_server -s ts install -s ts run all_tests -s init stop

# Test after building
echo to Test after building
echo launch script : $SOURCE997
ksh -x $SOURCE997
echo "STOP" ; exit 1

%install

export LIBPATH="/opt/freeware/lib"
export RM="/usr/bin/rm -f"
export AR="/usr/bin/ar"
export NM="/usr/bin/nm -X32_64"

%if %{__with_emacs}
# GNU Emacs/XEmacs related stuff
erlang_tools_vsn="$(sed -n 's/TOOLS_VSN = //p' lib/tools/vsn.mk)"

# GNU Emacs related stuff
install -m 0755 -d "$RPM_BUILD_ROOT%{_emacs_sitestartdir}"
install -m 0755 -d "$RPM_BUILD_ROOT%{_emacs_sitelispdir}/erlang"
install -m 0644 emacs-erlang-init.el "$RPM_BUILD_ROOT%{_emacs_sitestartdir}/erlang-init.el"
for f in lib/tools/emacs/{README,*.el}; do
	b="$(basename "$f")";
	ln -s "%{_libdir}/erlang/lib/tools-${erlang_tools_vsn}/emacs/$b" \
		"$RPM_BUILD_ROOT%{_emacs_sitelispdir}/erlang/"
done
install -m 0644 emacs-erlang/*.elc "$RPM_BUILD_ROOT%{_emacs_sitelispdir}/erlang/"

# XEmacs related stuff
install -m 0755 -d "$RPM_BUILD_ROOT%{_xemacs_sitestartdir}"
install -m 0755 -d "$RPM_BUILD_ROOT%{_xemacs_sitelispdir}/erlang"
install -m 0644 xemacs-erlang-init.el "$RPM_BUILD_ROOT%{_xemacs_sitestartdir}/erlang-init.el"
for f in lib/tools/emacs/{README,*.el}; do
	b="$(basename "$f")";
	ln -s "%{_libdir}/erlang/lib/tools-${erlang_tools_vsn}/emacs/$b" \
		"$RPM_BUILD_ROOT%{_xemacs_sitelispdir}/erlang/"
done
rm -f "$RPM_BUILD_ROOT%{_xemacs_sitelispdir}/erlang/erlang-flymake.el"
install -m 0644 xemacs-erlang/*.elc "$RPM_BUILD_ROOT%{_xemacs_sitelispdir}/erlang/"
%endif %{__with_emacs}

gmake DESTDIR=$RPM_BUILD_ROOT install

%if %{withdoc}
env ERL_LIBS="$RPM_BUILD_ROOT%{_libdir}/erlang/lib" gmake DESTDIR=$RPM_BUILD_ROOT install-docs
%endif

# Do not install info files - they are almost empty and useless
find $RPM_BUILD_ROOT%{_libdir}/erlang -type f -name info -exec rm -f {} \;

%if %{__with_examples}
# fix 0775 permission on some directories
find $RPM_BUILD_ROOT%{_libdir}/erlang/lib/ssl-*/examples/ -type d -perm 0775 -print -exec chmod 755 {} \;
find $RPM_BUILD_ROOT%{_libdir}/erlang/lib/kernel-*/examples/uds_dist -type d -perm 0775 -print -exec chmod 755 {} \;
%else
# Remove all examples
find $RPM_BUILD_ROOT%{_libdir}/erlang/lib/ -mindepth 1 -maxdepth 2 -type d -name examples -exec rm -rf {} \;
%endif %{__with_examples}

chmod 0755 $RPM_BUILD_ROOT%{_libdir}/erlang/bin

# Relocate doc-files into the proper directory
%if %{withdoc}
mkdir -p $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}/lib
pushd .
cd $RPM_BUILD_ROOT%{_libdir}/erlang
mv -v doc $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
for i in erts-* ; do mv -v $i/doc $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}/$i ; done
cd $RPM_BUILD_ROOT%{_libdir}/erlang/lib
for i in * ; do mv -v $i/doc $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}/lib/$i || true ; done
popd
cp -av AUTHORS LICENSE.txt README.md $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
mv -v $RPM_BUILD_ROOT%{_libdir}/erlang/PR.template $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
mv -v $RPM_BUILD_ROOT%{_libdir}/erlang/COPYRIGHT $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
# We'll package it by marking it explicitly as doc - see below
rm -f $RPM_BUILD_ROOT%{_libdir}/erlang/README.md
%endif

# Win32-specific man-pages
rm -f $RPM_BUILD_ROOT%{_libdir}/erlang/man/man1/erlsrv.*
rm -f $RPM_BUILD_ROOT%{_libdir}/erlang/man/man1/werl.*
rm -f $RPM_BUILD_ROOT%{_libdir}/erlang/man/man3/win32reg.*

# remove empty directory
rm -r $RPM_BUILD_ROOT%{_libdir}/erlang/erts-*/man

# remove outdated script
rm -f $RPM_BUILD_ROOT%{_libdir}/erlang/Install

# Replace identical executables with symlinks
for exe in $RPM_BUILD_ROOT%{_libdir}/erlang/erts-*/bin/*
do
	base="$(basename "$exe")"
	next="$RPM_BUILD_ROOT%{_libdir}/erlang/bin/${base}"
	rel="$(echo "$exe" | sed "s,^$RPM_BUILD_ROOT%{_libdir}/erlang/,../,")"
	if cmp "$exe" "$next"; then
		ln -sf "$rel" "$next"
	fi
done
for exe in $RPM_BUILD_ROOT%{_libdir}/erlang/bin/*
do
	base="$(basename "$exe")"
	next="$RPM_BUILD_ROOT%{_bindir}/${base}"
	rel="$(echo "$exe" | sed "s,^$RPM_BUILD_ROOT,,")"
	if cmp "$exe" "$next"; then
		ln -sf "$rel" "$next"
	fi
done

%if %{__with_java}
# symlink *.jar files to appropriate places for subpackages
install -m 0755 -d "$RPM_BUILD_ROOT%{_javadir}/%{name}"

# erlang-ic
ic_lib_dir="$(ls -d1 $RPM_BUILD_ROOT%{_libdir}/erlang/lib/ic-*/ | sed "s,^$RPM_BUILD_ROOT,,")"
test -d "$RPM_BUILD_ROOT$ic_lib_dir"
ln -s "${ic_lib_dir}priv/ic.jar" "$RPM_BUILD_ROOT%{_javadir}/%{name}/"

# erlang-jinterface
jinterface_lib_dir="$(ls -d1 $RPM_BUILD_ROOT%{_libdir}/erlang/lib/jinterface-*/ | sed "s,^$RPM_BUILD_ROOT,,")"
test -d "$RPM_BUILD_ROOT$jinterface_lib_dir"
ln -s "${jinterface_lib_dir}priv/OtpErlang.jar" "$RPM_BUILD_ROOT%{_javadir}/%{name}/"
%endif %{__with_java}

# systemd-related stuff
%if 0%{?el7}%{?fedora}
install -D -p -m 0644 %{SOURCE5} %{buildroot}%{_unitdir}/epmd.service
install -D -p -m 0644 %{SOURCE6} %{buildroot}%{_unitdir}/epmd.socket
install -D -p -m 0644 %{SOURCE7} %{buildroot}%{_unitdir}/epmd@.service
install -D -p -m 0644 %{SOURCE8} %{buildroot}%{_unitdir}/epmd@.socket
%endif


%if %{__with_wxwidgets}
echo "No need to fix additional scripts"
%else
# FIXME workaround for broken Erlang install procedure
for exe in ct_run dialyzer typer
do
	rm -f $RPM_BUILD_ROOT/%{_bindir}/${exe}
	rm -f $RPM_BUILD_ROOT/%{_libdir}/erlang/bin/${exe}
	rm -f $RPM_BUILD_ROOT/%{_libdir}/erlang/erts-*/bin/${exe}
done
%endif %{__with_wxwidgets}



#%check
# FIXME run tests somehow
# make tests || exit 0


%pre erts
getent group epmd >/dev/null || groupadd -r epmd
getent passwd epmd >/dev/null || \
useradd -r -g epmd -d /tmp -s /sbin/nologin \
-c "Erlang Port Mapper Daemon" epmd 2>/dev/null || :


%files
%if %{withdoc}
%dir %{_docdir}/%{name}-%{version}/
%doc %{_docdir}/%{name}-%{version}/AUTHORS
%doc %{_docdir}/%{name}-%{version}/COPYRIGHT
%doc %{_docdir}/%{name}-%{version}/LICENSE.txt
%doc %{_docdir}/%{name}-%{version}/PR.template
%doc %{_docdir}/%{name}-%{version}/README.md
%endif

%files asn1
%dir %{_libdir}/erlang/lib/asn1-*/
%{_libdir}/erlang/lib/asn1-*/ebin
%{_libdir}/erlang/lib/asn1-*/priv
%{_libdir}/erlang/lib/asn1-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/asn1ct.*
%{_libdir}/erlang/man/man3/asn1rt.*
%endif

%if %{__with_wxwidgets}
%files common_test
%{_bindir}/ct_run
%{_libdir}/erlang/bin/ct_run
%{_libdir}/erlang/erts-*/bin/ct_run
%{_libdir}/erlang/lib/common_test-*/
# For AIX
#%if %{withdoc}
#%{_libdir}/erlang/man/man1/ct_run.*
#%{_libdir}/erlang/man/man3/ct.*
#%{_libdir}/erlang/man/man3/ct_cover.*
#%{_libdir}/erlang/man/man3/ct_ftp.*
#%{_libdir}/erlang/man/man3/ct_hooks.*
#%{_libdir}/erlang/man/man3/ct_master.*
#%{_libdir}/erlang/man/man3/ct_netconfc.*
#%{_libdir}/erlang/man/man3/ct_property_test.*
#%{_libdir}/erlang/man/man3/ct_rpc.*
#%{_libdir}/erlang/man/man3/ct_slave.*
#%{_libdir}/erlang/man/man3/ct_snmp.*
#%{_libdir}/erlang/man/man3/ct_ssh.*
#%{_libdir}/erlang/man/man3/ct_telnet.*
#%{_libdir}/erlang/man/man3/unix_telnet.*
#%{_libdir}/erlang/man/man6/common_test.*
#%endif
%endif %{__with_wxwidgets}

%files compiler
%{_libdir}/erlang/lib/compiler-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/compile.*
%endif

%files cosEvent
%{_libdir}/erlang/lib/cosEvent-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/cosEventApp.*
%{_libdir}/erlang/man/man3/CosEventChannelAdmin.*
%{_libdir}/erlang/man/man3/CosEventChannelAdmin_ConsumerAdmin.*
%{_libdir}/erlang/man/man3/CosEventChannelAdmin_EventChannel.*
%{_libdir}/erlang/man/man3/CosEventChannelAdmin_ProxyPullConsumer.*
%{_libdir}/erlang/man/man3/CosEventChannelAdmin_ProxyPullSupplier.*
%{_libdir}/erlang/man/man3/CosEventChannelAdmin_ProxyPushConsumer.*
%{_libdir}/erlang/man/man3/CosEventChannelAdmin_ProxyPushSupplier.*
%{_libdir}/erlang/man/man3/CosEventChannelAdmin_SupplierAdmin.*
%endif

%files cosEventDomain
%{_libdir}/erlang/lib/cosEventDomain-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/CosEventDomainAdmin.*
%{_libdir}/erlang/man/man3/CosEventDomainAdmin_EventDomain.*
%{_libdir}/erlang/man/man3/CosEventDomainAdmin_EventDomainFactory.*
%{_libdir}/erlang/man/man3/cosEventDomainApp.*
%endif

%files cosFileTransfer
%dir %{_libdir}/erlang/lib/cosFileTransfer-*/
%{_libdir}/erlang/lib/cosFileTransfer-*/ebin
%{_libdir}/erlang/lib/cosFileTransfer-*/include
%{_libdir}/erlang/lib/cosFileTransfer-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/cosFileTransferApp.*
%{_libdir}/erlang/man/man3/CosFileTransfer_Directory.*
%{_libdir}/erlang/man/man3/CosFileTransfer_File.*
%{_libdir}/erlang/man/man3/CosFileTransfer_FileIterator.*
%{_libdir}/erlang/man/man3/CosFileTransfer_FileTransferSession.*
%{_libdir}/erlang/man/man3/CosFileTransfer_VirtualFileSystem.*
%endif

%files cosNotification
%dir %{_libdir}/erlang/lib/cosNotification-*/
%{_libdir}/erlang/lib/cosNotification-*/ebin
%{_libdir}/erlang/lib/cosNotification-*/include
%{_libdir}/erlang/lib/cosNotification-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/CosNotification.*
%{_libdir}/erlang/man/man3/CosNotification_AdminPropertiesAdmin.*
%{_libdir}/erlang/man/man3/cosNotificationApp.*
%{_libdir}/erlang/man/man3/CosNotification_QoSAdmin.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_ConsumerAdmin.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_EventChannel.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_EventChannelFactory.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_ProxyConsumer.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_ProxyPullConsumer.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_ProxyPullSupplier.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_ProxyPushConsumer.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_ProxyPushSupplier.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_ProxySupplier.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_SequenceProxyPullConsumer.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_SequenceProxyPullSupplier.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_SequenceProxyPushConsumer.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_SequenceProxyPushSupplier.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_StructuredProxyPullConsumer.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_StructuredProxyPullSupplier.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_StructuredProxyPushConsumer.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_StructuredProxyPushSupplier.*
%{_libdir}/erlang/man/man3/CosNotifyChannelAdmin_SupplierAdmin.*
%{_libdir}/erlang/man/man3/CosNotifyComm_NotifyPublish.*
%{_libdir}/erlang/man/man3/CosNotifyComm_NotifySubscribe.*
%{_libdir}/erlang/man/man3/CosNotifyFilter_Filter.*
%{_libdir}/erlang/man/man3/CosNotifyFilter_FilterAdmin.*
%{_libdir}/erlang/man/man3/CosNotifyFilter_FilterFactory.*
%{_libdir}/erlang/man/man3/CosNotifyFilter_MappingFilter.*
%endif

%files cosProperty
%dir %{_libdir}/erlang/lib/cosProperty-*/
%{_libdir}/erlang/lib/cosProperty-*/ebin
%{_libdir}/erlang/lib/cosProperty-*/include
%{_libdir}/erlang/lib/cosProperty-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/cosProperty.*
%{_libdir}/erlang/man/man3/CosPropertyService_PropertiesIterator.*
%{_libdir}/erlang/man/man3/CosPropertyService_PropertyNamesIterator.*
%{_libdir}/erlang/man/man3/CosPropertyService_PropertySet.*
%{_libdir}/erlang/man/man3/CosPropertyService_PropertySetDef.*
%{_libdir}/erlang/man/man3/CosPropertyService_PropertySetDefFactory.*
%{_libdir}/erlang/man/man3/CosPropertyService_PropertySetFactory.*
%endif

%files cosTime
%dir %{_libdir}/erlang/lib/cosTime-*/
%{_libdir}/erlang/lib/cosTime-*/ebin
%{_libdir}/erlang/lib/cosTime-*/include
%{_libdir}/erlang/lib/cosTime-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/cosTime.*
%{_libdir}/erlang/man/man3/CosTimerEvent_TimerEventHandler.*
%{_libdir}/erlang/man/man3/CosTimerEvent_TimerEventService.*
%{_libdir}/erlang/man/man3/CosTime_TimeService.*
%{_libdir}/erlang/man/man3/CosTime_TIO.*
%{_libdir}/erlang/man/man3/CosTime_UTO.*
%endif

%files cosTransactions
%dir %{_libdir}/erlang/lib/cosTransactions-*/
%{_libdir}/erlang/lib/cosTransactions-*/ebin
%{_libdir}/erlang/lib/cosTransactions-*/include
%{_libdir}/erlang/lib/cosTransactions-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/cosTransactions.*
%{_libdir}/erlang/man/man3/CosTransactions_Control.*
%{_libdir}/erlang/man/man3/CosTransactions_Coordinator.*
%{_libdir}/erlang/man/man3/CosTransactions_RecoveryCoordinator.*
%{_libdir}/erlang/man/man3/CosTransactions_Resource.*
%{_libdir}/erlang/man/man3/CosTransactions_SubtransactionAwareResource.*
%{_libdir}/erlang/man/man3/CosTransactions_Terminator.*
%{_libdir}/erlang/man/man3/CosTransactions_TransactionFactory.*
%endif

%files crypto
%{_libdir}/erlang/lib/crypto-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/crypto.*
%{_libdir}/erlang/man/man6/crypto.*
%endif

%if %{__with_wxwidgets}
%files debugger
%{_libdir}/erlang/lib/debugger-*/
# For AIX
#%if %{withdoc}
#%{_libdir}/erlang/man/man3/debugger.*
#%{_libdir}/erlang/man/man3/i.*
#%{_libdir}/erlang/man/man3/int.*
#%endif
%endif %{__with_wxwidgets}

%if %{__with_wxwidgets}
%files dialyzer
%{_bindir}/dialyzer
%{_libdir}/erlang/bin/dialyzer
%{_libdir}/erlang/erts-*/bin/dialyzer
%{_libdir}/erlang/lib/dialyzer-*/
# For AIX
#%if %{withdoc}
#%{_libdir}/erlang/man/man3/dialyzer.*
#%endif
%endif %{__with_wxwidgets}

%files diameter
%dir %{_libdir}/erlang/lib/diameter-*/
%{_libdir}/erlang/lib/diameter-*/bin
%{_libdir}/erlang/lib/diameter-*/ebin
%{_libdir}/erlang/lib/diameter-*/include
%{_libdir}/erlang/lib/diameter-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man1/diameterc.*
%{_libdir}/erlang/man/man3/diameter.*
%{_libdir}/erlang/man/man3/diameter_app.*
%{_libdir}/erlang/man/man3/diameter_codec.*
%{_libdir}/erlang/man/man3/diameter_make.*
%{_libdir}/erlang/man/man3/diameter_sctp.*
%{_libdir}/erlang/man/man3/diameter_tcp.*
%{_libdir}/erlang/man/man3/diameter_transport.*
%{_libdir}/erlang/man/man4/diameter_dict.*
%endif

%if %{withdoc}
%files doc
%doc %{_docdir}/%{name}-%{version}/doc
%doc %{_docdir}/%{name}-%{version}/erts-*/
%doc %{_docdir}/%{name}-%{version}/lib/
%endif

%files edoc
%{_libdir}/erlang/lib/edoc-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/edoc.*
%{_libdir}/erlang/man/man3/edoc_doclet.*
%{_libdir}/erlang/man/man3/edoc_extract.*
%{_libdir}/erlang/man/man3/edoc_layout.*
%{_libdir}/erlang/man/man3/edoc_lib.*
%{_libdir}/erlang/man/man3/edoc_run.*
%endif

%files eldap
%{_libdir}/erlang/lib/eldap-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/eldap.*
%endif

%files erl_docgen
%{_libdir}/erlang/lib/erl_docgen-*/
%if %{withdoc}
%{_libdir}/erlang/man/man6/erl_docgen.*
%endif

%files erl_interface
%{_libdir}/erlang/lib/erl_interface-*/
%if %{withdoc}
%{_libdir}/erlang/man/man1/erl_call.*
%{_libdir}/erlang/man/man3/ei.*
%{_libdir}/erlang/man/man3/ei_connect.*
%{_libdir}/erlang/man/man3/erl_connect.*
%{_libdir}/erlang/man/man3/erl_error.*
%{_libdir}/erlang/man/man3/erl_eterm.*
%{_libdir}/erlang/man/man3/erl_format.*
%{_libdir}/erlang/man/man3/erl_global.*
%{_libdir}/erlang/man/man3/erl_malloc.*
%{_libdir}/erlang/man/man3/erl_marshal.*
%{_libdir}/erlang/man/man3/registry.*
%endif

%files erts
# TODO
# In order to have a parallel-installable Erlang packages these directories
# should be packaged separately
%dir %{_libdir}/erlang/
%dir %{_libdir}/erlang/bin/
%dir %{_libdir}/erlang/lib/
%if %{withdoc}
%dir %{_libdir}/erlang/man/
%dir %{_libdir}/erlang/man/man1/
%dir %{_libdir}/erlang/man/man3/
%dir %{_libdir}/erlang/man/man4/
%dir %{_libdir}/erlang/man/man6/
%dir %{_libdir}/erlang/man/man7/
%endif
%dir %{_libdir}/erlang/releases/

%{_bindir}/epmd
%{_bindir}/erl
%{_bindir}/erlc
%{_bindir}/escript
%{_bindir}/run_erl
%{_bindir}/to_erl
%{_libdir}/erlang/bin/epmd
%{_libdir}/erlang/bin/erl
%{_libdir}/erlang/bin/erlc
%{_libdir}/erlang/bin/escript
%{_libdir}/erlang/bin/no_dot_erlang.boot
%{_libdir}/erlang/bin/run_erl
%{_libdir}/erlang/bin/start
%{_libdir}/erlang/bin/start.boot
%{_libdir}/erlang/bin/start.script
%{_libdir}/erlang/bin/start_clean.boot
%{_libdir}/erlang/bin/start_erl
%{_libdir}/erlang/bin/start_sasl.boot
%{_libdir}/erlang/bin/to_erl
%dir %{_libdir}/erlang/erts-*/
%dir %{_libdir}/erlang/erts-*/bin/
%{_libdir}/erlang/erts-*/bin/beam
%{_libdir}/erlang/erts-*/bin/beam.smp
%{_libdir}/erlang/erts-*/bin/dyn_erl
%{_libdir}/erlang/erts-*/bin/epmd
%{_libdir}/erlang/erts-*/bin/erl
%{_libdir}/erlang/erts-*/bin/erl.src
%{_libdir}/erlang/erts-*/bin/erl_child_setup
%{_libdir}/erlang/erts-*/bin/erlc
%{_libdir}/erlang/erts-*/bin/erlexec
%{_libdir}/erlang/erts-*/bin/escript
%{_libdir}/erlang/erts-*/bin/heart
%{_libdir}/erlang/erts-*/bin/inet_gethost
%{_libdir}/erlang/erts-*/bin/run_erl
%{_libdir}/erlang/erts-*/bin/start
%{_libdir}/erlang/erts-*/bin/start.src
%{_libdir}/erlang/erts-*/bin/start_erl.src
%{_libdir}/erlang/erts-*/bin/to_erl
%{_libdir}/erlang/erts-*/include
%{_libdir}/erlang/erts-*/lib/
%{_libdir}/erlang/erts-*/src/
%{_libdir}/erlang/lib/erts-*/
%if %{withdoc}
%{_libdir}/erlang/man/man1/epmd.*
%{_libdir}/erlang/man/man1/erl.*
%{_libdir}/erlang/man/man1/erlc.*
%{_libdir}/erlang/man/man1/escript.*
%{_libdir}/erlang/man/man1/run_erl.*
%{_libdir}/erlang/man/man1/start.*
%{_libdir}/erlang/man/man1/start_erl.*
%{_libdir}/erlang/man/man3/driver_entry.*
%{_libdir}/erlang/man/man3/erl_driver.*
%{_libdir}/erlang/man/man3/erl_nif.*
%{_libdir}/erlang/man/man3/erl_prim_loader.*
%{_libdir}/erlang/man/man3/erl_tracer.*
%{_libdir}/erlang/man/man3/erlang.*
%{_libdir}/erlang/man/man3/erts_alloc.*
%{_libdir}/erlang/man/man3/init.*
%{_libdir}/erlang/man/man3/zlib.*
%endif
%{_libdir}/erlang/releases/*
%{_libdir}/erlang/usr/
%if 0%{?el7}%{?fedora}
%{_unitdir}/epmd.service
%{_unitdir}/epmd.socket
%{_unitdir}/epmd@.service
%{_unitdir}/epmd@.socket
%endif

%if %{__with_wxwidgets}
%files et
%dir %{_libdir}/erlang/lib/et-*/
%{_libdir}/erlang/lib/et-*/ebin
%{_libdir}/erlang/lib/et-*/include
%{_libdir}/erlang/lib/et-*/src
# For AIX
#%if %{withdoc}
#%{_libdir}/erlang/man/man3/et.*
#%{_libdir}/erlang/man/man3/et_collector.*
#%{_libdir}/erlang/man/man3/et_selector.*
#%{_libdir}/erlang/man/man3/et_viewer.*
#%endif
%endif %{__with_wxwidgets}

%files eunit
%dir %{_libdir}/erlang/lib/eunit-*/
%{_libdir}/erlang/lib/eunit-*/ebin
%{_libdir}/erlang/lib/eunit-*/include
%{_libdir}/erlang/lib/eunit-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/eunit.*
%{_libdir}/erlang/man/man3/eunit_surefire.*
%endif

%if %{__with_examples}
%files examples
%{_libdir}/erlang/lib/asn1-*/examples/
%{_libdir}/erlang/lib/diameter-*/examples/
%if %{__with_wxwidgets}
%{_libdir}/erlang/lib/et-*/examples/
%endif %{__with_wxwidgets}
%{_libdir}/erlang/lib/eunit-*/examples/
%if %{__with_tcltk}
%{_libdir}/erlang/lib/gs-*/examples/
%endif %{__with_tcltk}
%if %{__with_java}
%{_libdir}/erlang/lib/ic-*/examples/
%endif %{__with_java}
%{_libdir}/erlang/lib/inets-*/examples/
%{_libdir}/erlang/lib/kernel-*/examples/
%{_libdir}/erlang/lib/megaco-*/examples/
%{_libdir}/erlang/lib/mnesia-*/examples/
%if %{__with_wxwidgets}
%{_libdir}/erlang/lib/observer-*/examples/
%endif %{__with_wxwidgets}
%{_libdir}/erlang/lib/orber-*/examples/
%if %{__with_wxwidgets}
%{_libdir}/erlang/lib/reltool-*/examples/
%endif %{__with_wxwidgets}
%{_libdir}/erlang/lib/runtime_tools-*/examples/
%{_libdir}/erlang/lib/sasl-*/examples/
%{_libdir}/erlang/lib/snmp-*/examples/
%{_libdir}/erlang/lib/ssl-*/examples/
%{_libdir}/erlang/lib/stdlib-*/examples/
%{_libdir}/erlang/lib/syntax_tools-*/examples/
%{_libdir}/erlang/lib/tools-*/examples/
%if %{__with_wxwidgets}
%{_libdir}/erlang/lib/wx-*/examples/
%endif %{__with_wxwidgets}
%endif %{__with_examples}

%if %{__with_tcltk}
%files gs
%dir %{_libdir}/erlang/lib/gs-*/
%{_libdir}/erlang/lib/gs-*/ebin
%{_libdir}/erlang/lib/gs-*/priv
%{_libdir}/erlang/lib/gs-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/gs.*
%endif
%endif %{__with_tcltk}

%files hipe
%{_libdir}/erlang/lib/hipe-*/

%files ic
%dir %{_libdir}/erlang/lib/ic-*/
%{_libdir}/erlang/lib/ic-*/ebin
%{_libdir}/erlang/lib/ic-*/include
%{_libdir}/erlang/lib/ic-*/priv
%{_libdir}/erlang/lib/ic-*/src
# FIXME see erlang-jinterface also
#%dir %{_javadir}/%{name}/
%if %{__with_java}
%{_javadir}/%{name}/ic.jar
%endif %{__with_java}
%if %{withdoc}
%{_libdir}/erlang/man/man3/ic.*
%{_libdir}/erlang/man/man3/ic_clib.*
%{_libdir}/erlang/man/man3/ic_c_protocol.*
%endif

%files inets
%dir %{_libdir}/erlang/lib/inets-*/
%{_libdir}/erlang/lib/inets-*/ebin
%{_libdir}/erlang/lib/inets-*/include
%{_libdir}/erlang/lib/inets-*/priv
%{_libdir}/erlang/lib/inets-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/ftp.*
%{_libdir}/erlang/man/man3/http_uri.*
%{_libdir}/erlang/man/man3/httpc.*
%{_libdir}/erlang/man/man3/httpd.*
%{_libdir}/erlang/man/man3/httpd_custom_api.*
%{_libdir}/erlang/man/man3/httpd_socket.*
%{_libdir}/erlang/man/man3/httpd_util.*
%{_libdir}/erlang/man/man3/inets.*
%{_libdir}/erlang/man/man3/mod_alias.*
%{_libdir}/erlang/man/man3/mod_auth.*
%{_libdir}/erlang/man/man3/mod_esi.*
%{_libdir}/erlang/man/man3/mod_security.*
%{_libdir}/erlang/man/man3/tftp.*
%endif

%if %{__with_java}
%files jinterface
# FIXME see erlang-ic also
#%dir %{_javadir}/%{name}/
%{_javadir}/%{name}/OtpErlang.jar
%{_libdir}/erlang/lib/jinterface-*/
%endif %{__with_java}

%files kernel
%dir %{_libdir}/erlang/lib/kernel-*/
%{_libdir}/erlang/lib/kernel-*/ebin
%{_libdir}/erlang/lib/kernel-*/include
%{_libdir}/erlang/lib/kernel-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/application.*
%{_libdir}/erlang/man/man3/auth.*
%{_libdir}/erlang/man/man3/code.*
%{_libdir}/erlang/man/man3/disk_log.*
%{_libdir}/erlang/man/man3/erl_boot_server.*
%{_libdir}/erlang/man/man3/erl_ddll.*
%{_libdir}/erlang/man/man3/erl_prim_loader_stub.*
%{_libdir}/erlang/man/man3/erlang_stub.*
%{_libdir}/erlang/man/man3/error_handler.*
%{_libdir}/erlang/man/man3/error_logger.*
%{_libdir}/erlang/man/man3/file.*
%{_libdir}/erlang/man/man3/gen_sctp.*
%{_libdir}/erlang/man/man3/gen_tcp.*
%{_libdir}/erlang/man/man3/gen_udp.*
%{_libdir}/erlang/man/man3/global.*
%{_libdir}/erlang/man/man3/global_group.*
%{_libdir}/erlang/man/man3/heart.*
%{_libdir}/erlang/man/man3/inet.*
%{_libdir}/erlang/man/man3/inet_res.*
%{_libdir}/erlang/man/man3/init_stub.*
%{_libdir}/erlang/man/man3/net_adm.*
%{_libdir}/erlang/man/man3/net_kernel.*
%{_libdir}/erlang/man/man3/os.*
%{_libdir}/erlang/man/man3/pg2.*
%{_libdir}/erlang/man/man3/rpc.*
%{_libdir}/erlang/man/man3/seq_trace.*
%{_libdir}/erlang/man/man3/user.*
%{_libdir}/erlang/man/man3/wrap_log_reader.*
%{_libdir}/erlang/man/man3/zlib_stub.*
%{_libdir}/erlang/man/man4/app.*
%{_libdir}/erlang/man/man4/config.*
%{_libdir}/erlang/man/man6/kernel.*
%endif

%if %{__with_wxwidgets}
%files megaco
%dir %{_libdir}/erlang/lib/megaco-*/
%{_libdir}/erlang/lib/megaco-*/ebin
%{_libdir}/erlang/lib/megaco-*/include
%{_libdir}/erlang/lib/megaco-*/priv
%{_libdir}/erlang/lib/megaco-*/src
# For AIX
#%if %{withdoc}
#%{_libdir}/erlang/man/man3/megaco.*
#%{_libdir}/erlang/man/man3/megaco_codec_meas.*
#%{_libdir}/erlang/man/man3/megaco_codec_mstone1.*
#%{_libdir}/erlang/man/man3/megaco_codec_mstone2.*
#%{_libdir}/erlang/man/man3/megaco_codec_transform.*
#%{_libdir}/erlang/man/man3/megaco_edist_compress.*
#%{_libdir}/erlang/man/man3/megaco_encoder.*
#%{_libdir}/erlang/man/man3/megaco_flex_scanner.*
#%{_libdir}/erlang/man/man3/megaco_tcp.*
#%{_libdir}/erlang/man/man3/megaco_transport.*
#%{_libdir}/erlang/man/man3/megaco_udp.*
#%{_libdir}/erlang/man/man3/megaco_user.*
#%endif
%endif %{__with_wxwidgets}

%files mnesia
%dir %{_libdir}/erlang/lib/mnesia-*/
%{_libdir}/erlang/lib/mnesia-*/ebin
%{_libdir}/erlang/lib/mnesia-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/mnesia.*
%{_libdir}/erlang/man/man3/mnesia_frag_hash.*
%{_libdir}/erlang/man/man3/mnesia_registry.*
%endif

%if %{__with_wxwidgets}
%files observer
%dir %{_libdir}/erlang/lib/observer-*/
%{_libdir}/erlang/lib/observer-*/ebin/
%{_libdir}/erlang/lib/observer-*/include/
%{_libdir}/erlang/lib/observer-*/priv/
%{_libdir}/erlang/lib/observer-*/src/
# For AIX
#%if %{withdoc}
#%{_libdir}/erlang/man/man1/cdv.*
#%{_libdir}/erlang/man/man3/crashdump.*
#%{_libdir}/erlang/man/man3/etop.*
#%{_libdir}/erlang/man/man3/observer.*
#%{_libdir}/erlang/man/man3/ttb.*
#%{_libdir}/erlang/man/man6/observer.*
#%endif
%endif %{__with_wxwidgets}

%files odbc
%{_libdir}/erlang/lib/odbc-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/odbc.*
%endif

%files orber
%dir %{_libdir}/erlang/lib/orber-*/
%{_libdir}/erlang/lib/orber-*/COSS
%{_libdir}/erlang/lib/orber-*/ebin
%{_libdir}/erlang/lib/orber-*/include
%{_libdir}/erlang/lib/orber-*/java_src
%{_libdir}/erlang/lib/orber-*/priv
%{_libdir}/erlang/lib/orber-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/CosNaming.*
%{_libdir}/erlang/man/man3/CosNaming_BindingIterator.*
%{_libdir}/erlang/man/man3/CosNaming_NamingContext.*
%{_libdir}/erlang/man/man3/CosNaming_NamingContextExt.*
%{_libdir}/erlang/man/man3/Module_Interface.*
%{_libdir}/erlang/man/man3/any.*
%{_libdir}/erlang/man/man3/corba.*
%{_libdir}/erlang/man/man3/corba_object.*
%{_libdir}/erlang/man/man3/fixed.*
%{_libdir}/erlang/man/man3/interceptors.*
%{_libdir}/erlang/man/man3/lname.*
%{_libdir}/erlang/man/man3/lname_component.*
%{_libdir}/erlang/man/man3/orber.*
%{_libdir}/erlang/man/man3/orber_acl.*
%{_libdir}/erlang/man/man3/orber_diagnostics.*
%{_libdir}/erlang/man/man3/orber_ifr.*
%{_libdir}/erlang/man/man3/orber_tc.*
%endif

%files os_mon
%{_libdir}/erlang/lib/os_mon-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/cpu_sup.*
%{_libdir}/erlang/man/man3/disksup.*
%{_libdir}/erlang/man/man3/memsup.*
%{_libdir}/erlang/man/man3/os_mon_mib.*
%{_libdir}/erlang/man/man3/os_sup.*
%{_libdir}/erlang/man/man6/os_mon.*
%endif

%files otp_mibs
%{_libdir}/erlang/lib/otp_mibs-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/otp_mib.*
%endif

%files parsetools
%{_libdir}/erlang/lib/parsetools-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/leex.*
%{_libdir}/erlang/man/man3/yecc.*
%endif

%files percept
%{_libdir}/erlang/lib/percept-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/egd.*
%{_libdir}/erlang/man/man3/percept.*
%{_libdir}/erlang/man/man3/percept_profile.*
%endif

%files public_key
%{_libdir}/erlang/lib/public_key-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/public_key.*
%{_libdir}/erlang/man/man6/public_key.*
%endif

%if %{__with_wxwidgets}
%files reltool
%dir %{_libdir}/erlang/lib/reltool-*/
%{_libdir}/erlang/lib/reltool-*/ebin
%{_libdir}/erlang/lib/reltool-*/src
# For AIX
#%if %{withdoc}
#%{_libdir}/erlang/man/man3/reltool.*
#%endif
%endif %{__with_wxwidgets}

%files runtime_tools
%dir %{_libdir}/erlang/lib/runtime_tools-*/
%{_libdir}/erlang/lib/runtime_tools-*/ebin/
%{_libdir}/erlang/lib/runtime_tools-*/include/
%{_libdir}/erlang/lib/runtime_tools-*/priv/
%if %{withdoc}
%{_libdir}/erlang/man/man3/dbg.*
%{_libdir}/erlang/man/man3/dyntrace.*
%{_libdir}/erlang/man/man3/erts_alloc_config.*
%{_libdir}/erlang/man/man3/msacc.*
%{_libdir}/erlang/man/man3/system_information.*
%{_libdir}/erlang/man/man6/runtime_tools.*
%endif

%files sasl
%dir %{_libdir}/erlang/lib/sasl-*/
%{_libdir}/erlang/lib/sasl-*/ebin
%{_libdir}/erlang/lib/sasl-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/alarm_handler.*
%{_libdir}/erlang/man/man3/rb.*
%{_libdir}/erlang/man/man3/release_handler.*
%{_libdir}/erlang/man/man3/systools.*
%{_libdir}/erlang/man/man4/appup.*
%{_libdir}/erlang/man/man4/rel.*
%{_libdir}/erlang/man/man4/relup.*
%{_libdir}/erlang/man/man4/script.*
%{_libdir}/erlang/man/man6/sasl.*
%endif

%files snmp
%dir %{_libdir}/erlang/lib/snmp-*/
%{_libdir}/erlang/lib/snmp-*/bin
%{_libdir}/erlang/lib/snmp-*/ebin
%{_libdir}/erlang/lib/snmp-*/include
%{_libdir}/erlang/lib/snmp-*/mibs
%{_libdir}/erlang/lib/snmp-*/priv
%{_libdir}/erlang/lib/snmp-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man1/snmpc.*
%{_libdir}/erlang/man/man3/snmp.*
%{_libdir}/erlang/man/man3/snmpa.*
%{_libdir}/erlang/man/man3/snmpa_conf.*
%{_libdir}/erlang/man/man3/snmpa_discovery_handler.*
%{_libdir}/erlang/man/man3/snmpa_error.*
%{_libdir}/erlang/man/man3/snmpa_error_io.*
%{_libdir}/erlang/man/man3/snmpa_error_logger.*
%{_libdir}/erlang/man/man3/snmpa_error_report.*
%{_libdir}/erlang/man/man3/snmpa_local_db.*
%{_libdir}/erlang/man/man3/snmpa_mib_data.*
%{_libdir}/erlang/man/man3/snmpa_mib_storage.*
%{_libdir}/erlang/man/man3/snmpa_mpd.*
%{_libdir}/erlang/man/man3/snmpa_network_interface.*
%{_libdir}/erlang/man/man3/snmpa_network_interface_filter.*
%{_libdir}/erlang/man/man3/snmpa_notification_delivery_info_receiver.*
%{_libdir}/erlang/man/man3/snmpa_notification_filter.*
%{_libdir}/erlang/man/man3/snmpa_supervisor.*
%{_libdir}/erlang/man/man3/snmpc.*
%{_libdir}/erlang/man/man3/snmp_community_mib.*
%{_libdir}/erlang/man/man3/snmp_framework_mib.*
%{_libdir}/erlang/man/man3/snmp_generic.*
%{_libdir}/erlang/man/man3/snmp_index.*
%{_libdir}/erlang/man/man3/snmpm.*
%{_libdir}/erlang/man/man3/snmpm_conf.*
%{_libdir}/erlang/man/man3/snmpm_mpd.*
%{_libdir}/erlang/man/man3/snmpm_network_interface.*
%{_libdir}/erlang/man/man3/snmpm_network_interface_filter.*
%{_libdir}/erlang/man/man3/snmpm_user.*
%{_libdir}/erlang/man/man3/snmp_notification_mib.*
%{_libdir}/erlang/man/man3/snmp_pdus.*
%{_libdir}/erlang/man/man3/snmp_standard_mib.*
%{_libdir}/erlang/man/man3/snmp_target_mib.*
%{_libdir}/erlang/man/man3/snmp_user_based_sm_mib.*
%{_libdir}/erlang/man/man3/snmp_view_based_acm_mib.*
%{_libdir}/erlang/man/man6/snmp.*
%{_libdir}/erlang/man/man7/INET-ADDRESS-MIB.*
%{_libdir}/erlang/man/man7/OTP-SNMPEA-MIB.*
%{_libdir}/erlang/man/man7/RFC1213-MIB.*
%{_libdir}/erlang/man/man7/SNMP-COMMUNITY-MIB.*
%{_libdir}/erlang/man/man7/SNMP-FRAMEWORK-MIB.*
%{_libdir}/erlang/man/man7/SNMP-MPD-MIB.*
%{_libdir}/erlang/man/man7/SNMP-NOTIFICATION-MIB.*
%{_libdir}/erlang/man/man7/SNMP-TARGET-MIB.*
%{_libdir}/erlang/man/man7/SNMP-USER-BASED-SM-MIB.*
%{_libdir}/erlang/man/man7/SNMP-USM-AES-MIB.*
%{_libdir}/erlang/man/man7/SNMPv2-MIB.*
%{_libdir}/erlang/man/man7/SNMPv2-TM.*
%{_libdir}/erlang/man/man7/SNMP-VIEW-BASED-ACM-MIB.*
%{_libdir}/erlang/man/man7/STANDARD-MIB.*
%{_libdir}/erlang/man/man7/TRANSPORT-ADDRESS-MIB.*
%endif

%files ssh
%dir %{_libdir}/erlang/lib/ssh-*/
%{_libdir}/erlang/lib/ssh-*/ebin
%{_libdir}/erlang/lib/ssh-*/include
%{_libdir}/erlang/lib/ssh-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/ssh.*
%{_libdir}/erlang/man/man3/ssh_channel.*
%{_libdir}/erlang/man/man3/ssh_client_key_api.*
%{_libdir}/erlang/man/man3/ssh_connection.*
%{_libdir}/erlang/man/man3/ssh_server_key_api.*
%{_libdir}/erlang/man/man3/ssh_sftp.*
%{_libdir}/erlang/man/man3/ssh_sftpd.*
%{_libdir}/erlang/man/man6/ssh.*
%endif

%files ssl
%dir %{_libdir}/erlang/lib/ssl-*/
%{_libdir}/erlang/lib/ssl-*/ebin
%{_libdir}/erlang/lib/ssl-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/ssl.*
%{_libdir}/erlang/man/man3/ssl_crl_cache.*
%{_libdir}/erlang/man/man3/ssl_crl_cache_api.*
%{_libdir}/erlang/man/man3/ssl_session_cache_api.*
%{_libdir}/erlang/man/man6/ssl.*
%endif

%files stdlib
%dir %{_libdir}/erlang/lib/stdlib-*/
%{_libdir}/erlang/lib/stdlib-*/ebin
%{_libdir}/erlang/lib/stdlib-*/include
%{_libdir}/erlang/lib/stdlib-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/array.*
%{_libdir}/erlang/man/man3/base64.*
%{_libdir}/erlang/man/man3/beam_lib.*
%{_libdir}/erlang/man/man3/binary.*
%{_libdir}/erlang/man/man3/c.*
%{_libdir}/erlang/man/man3/calendar.*
%{_libdir}/erlang/man/man3/dets.*
%{_libdir}/erlang/man/man3/dict.*
%{_libdir}/erlang/man/man3/digraph.*
%{_libdir}/erlang/man/man3/digraph_utils.*
%{_libdir}/erlang/man/man3/epp.*
%{_libdir}/erlang/man/man3/erl_anno.*
%{_libdir}/erlang/man/man3/erl_eval.*
%{_libdir}/erlang/man/man3/erl_expand_records.*
%{_libdir}/erlang/man/man3/erl_id_trans.*
%{_libdir}/erlang/man/man3/erl_internal.*
%{_libdir}/erlang/man/man3/erl_lint.*
%{_libdir}/erlang/man/man3/erl_parse.*
%{_libdir}/erlang/man/man3/erl_pp.*
%{_libdir}/erlang/man/man3/erl_scan.*
%{_libdir}/erlang/man/man3/erl_tar.*
%{_libdir}/erlang/man/man3/ets.*
%{_libdir}/erlang/man/man3/file_sorter.*
%{_libdir}/erlang/man/man3/filelib.*
%{_libdir}/erlang/man/man3/filename.*
%{_libdir}/erlang/man/man3/gb_sets.*
%{_libdir}/erlang/man/man3/gb_trees.*
%{_libdir}/erlang/man/man3/gen_event.*
%{_libdir}/erlang/man/man3/gen_fsm.*
%{_libdir}/erlang/man/man3/gen_server.*
%{_libdir}/erlang/man/man3/gen_statem.*
%{_libdir}/erlang/man/man3/io.*
%{_libdir}/erlang/man/man3/io_lib.*
%{_libdir}/erlang/man/man3/lib.*
%{_libdir}/erlang/man/man3/lists.*
%{_libdir}/erlang/man/man3/log_mf_h.*
%{_libdir}/erlang/man/man3/maps.*
%{_libdir}/erlang/man/man3/math.*
%{_libdir}/erlang/man/man3/ms_transform.*
%{_libdir}/erlang/man/man3/orddict.*
%{_libdir}/erlang/man/man3/ordsets.*
%{_libdir}/erlang/man/man3/pool.*
%{_libdir}/erlang/man/man3/proc_lib.*
%{_libdir}/erlang/man/man3/proplists.*
%{_libdir}/erlang/man/man3/qlc.*
%{_libdir}/erlang/man/man3/queue.*
%{_libdir}/erlang/man/man3/rand.*
%{_libdir}/erlang/man/man3/random.*
%{_libdir}/erlang/man/man3/re.*
%{_libdir}/erlang/man/man3/sets.*
%{_libdir}/erlang/man/man3/shell.*
%{_libdir}/erlang/man/man3/shell_default.*
%{_libdir}/erlang/man/man3/slave.*
%{_libdir}/erlang/man/man3/sofs.*
%{_libdir}/erlang/man/man3/string.*
%{_libdir}/erlang/man/man3/supervisor.*
%{_libdir}/erlang/man/man3/supervisor_bridge.*
%{_libdir}/erlang/man/man3/sys.*
%{_libdir}/erlang/man/man3/timer.*
%{_libdir}/erlang/man/man3/unicode.*
%{_libdir}/erlang/man/man3/zip.*
%{_libdir}/erlang/man/man6/stdlib.*
%endif

%files syntax_tools
%dir %{_libdir}/erlang/lib/syntax_tools-*/
%{_libdir}/erlang/lib/syntax_tools-*/ebin
%{_libdir}/erlang/lib/syntax_tools-*/include
%if %{withdoc}
%{_libdir}/erlang/man/man3/epp_dodger.*
%{_libdir}/erlang/man/man3/erl_comment_scan.*
%{_libdir}/erlang/man/man3/erl_prettypr.*
%{_libdir}/erlang/man/man3/erl_recomment.*
%{_libdir}/erlang/man/man3/erl_syntax.*
%{_libdir}/erlang/man/man3/erl_syntax_lib.*
%{_libdir}/erlang/man/man3/erl_tidy.*
%{_libdir}/erlang/man/man3/igor.*
%{_libdir}/erlang/man/man3/merl.*
%{_libdir}/erlang/man/man3/merl_transform.*
%{_libdir}/erlang/man/man3/prettypr.*
%endif

%files tools
%dir %{_libdir}/erlang/lib/tools-*/
%{_libdir}/erlang/lib/tools-*/bin
%{_libdir}/erlang/lib/tools-*/ebin
%{_libdir}/erlang/lib/tools-*/emacs
%{_libdir}/erlang/lib/tools-*/src
%if %{withdoc}
%{_libdir}/erlang/man/man3/cover.*
%{_libdir}/erlang/man/man3/cprof.*
%{_libdir}/erlang/man/man3/eprof.*
%{_libdir}/erlang/man/man3/erlang_mode.*
%{_libdir}/erlang/man/man3/fprof.*
%{_libdir}/erlang/man/man3/instrument.*
%{_libdir}/erlang/man/man3/lcnt.*
%{_libdir}/erlang/man/man3/make.*
%{_libdir}/erlang/man/man3/tags.*
%{_libdir}/erlang/man/man3/xref.*
%endif
%if %{__with_emacs}
%dir %{_emacs_sitelispdir}/erlang
%dir %{_xemacs_sitelispdir}/erlang
%doc %{_emacs_sitelispdir}/erlang/README
%doc %{_xemacs_sitelispdir}/erlang/README
%{_emacs_sitelispdir}/erlang/*.el
%{_emacs_sitelispdir}/erlang/*.elc
%{_emacs_sitestartdir}/erlang-init.el
%{_xemacs_sitelispdir}/erlang/*.el
%{_xemacs_sitelispdir}/erlang/*.elc
%{_xemacs_sitestartdir}/erlang-init.el
%endif %{__with_emacs}


%if %{__with_wxwidgets}
%files typer
%{_bindir}/typer
%{_libdir}/erlang/bin/typer
%{_libdir}/erlang/erts-*/bin/typer
%dir %{_libdir}/erlang/lib/typer-*/
%{_libdir}/erlang/lib/typer-*/ebin/
%endif %{__with_wxwidgets}

%if %{__with_wxwidgets}
%files wx
%dir %{_libdir}/erlang/lib/wx-*/
%{_libdir}/erlang/lib/wx-*/ebin
%{_libdir}/erlang/lib/wx-*/include
%{_libdir}/erlang/lib/wx-*/priv
%{_libdir}/erlang/lib/wx-*/src
# For AIX
#%if %{withdoc}
#%{_libdir}/erlang/man/man3/gl.*
#%{_libdir}/erlang/man/man3/glu.*
#%{_libdir}/erlang/man/man3/wx.*
#%{_libdir}/erlang/man/man3/wx_misc.*
#%{_libdir}/erlang/man/man3/wx_object.*
#%{_libdir}/erlang/man/man3/wxAcceleratorEntry.*
#%{_libdir}/erlang/man/man3/wxAcceleratorTable.*
#%{_libdir}/erlang/man/man3/wxActivateEvent.*
#%{_libdir}/erlang/man/man3/wxArtProvider.*
#%{_libdir}/erlang/man/man3/wxAuiDockArt.*
#%{_libdir}/erlang/man/man3/wxAuiManager.*
#%{_libdir}/erlang/man/man3/wxAuiManagerEvent.*
#%{_libdir}/erlang/man/man3/wxAuiNotebook.*
#%{_libdir}/erlang/man/man3/wxAuiNotebookEvent.*
#%{_libdir}/erlang/man/man3/wxAuiPaneInfo.*
#%{_libdir}/erlang/man/man3/wxAuiSimpleTabArt.*
#%{_libdir}/erlang/man/man3/wxAuiTabArt.*
#%{_libdir}/erlang/man/man3/wxBitmap.*
#%{_libdir}/erlang/man/man3/wxBitmapButton.*
#%{_libdir}/erlang/man/man3/wxBitmapDataObject.*
#%{_libdir}/erlang/man/man3/wxBoxSizer.*
#%{_libdir}/erlang/man/man3/wxBrush.*
#%{_libdir}/erlang/man/man3/wxBufferedDC.*
#%{_libdir}/erlang/man/man3/wxBufferedPaintDC.*
#%{_libdir}/erlang/man/man3/wxButton.*
#%{_libdir}/erlang/man/man3/wxCalendarCtrl.*
#%{_libdir}/erlang/man/man3/wxCalendarDateAttr.*
#%{_libdir}/erlang/man/man3/wxCalendarEvent.*
#%{_libdir}/erlang/man/man3/wxCaret.*
#%{_libdir}/erlang/man/man3/wxCheckBox.*
#%{_libdir}/erlang/man/man3/wxCheckListBox.*
#%{_libdir}/erlang/man/man3/wxChildFocusEvent.*
#%{_libdir}/erlang/man/man3/wxChoice.*
#%{_libdir}/erlang/man/man3/wxChoicebook.*
#%{_libdir}/erlang/man/man3/wxClientDC.*
#%{_libdir}/erlang/man/man3/wxClipboard.*
#%{_libdir}/erlang/man/man3/wxClipboardTextEvent.*
#%{_libdir}/erlang/man/man3/wxCloseEvent.*
#%{_libdir}/erlang/man/man3/wxColourData.*
#%{_libdir}/erlang/man/man3/wxColourDialog.*
#%{_libdir}/erlang/man/man3/wxColourPickerCtrl.*
#%{_libdir}/erlang/man/man3/wxColourPickerEvent.*
#%{_libdir}/erlang/man/man3/wxComboBox.*
#%{_libdir}/erlang/man/man3/wxCommandEvent.*
#%{_libdir}/erlang/man/man3/wxContextMenuEvent.*
#%{_libdir}/erlang/man/man3/wxControl.*
#%{_libdir}/erlang/man/man3/wxControlWithItems.*
#%{_libdir}/erlang/man/man3/wxCursor.*
#%{_libdir}/erlang/man/man3/wxDataObject.*
#%{_libdir}/erlang/man/man3/wxDateEvent.*
#%{_libdir}/erlang/man/man3/wxDatePickerCtrl.*
#%{_libdir}/erlang/man/man3/wxDC.*
#%{_libdir}/erlang/man/man3/wxDCOverlay.*
#%{_libdir}/erlang/man/man3/wxDialog.*
#%{_libdir}/erlang/man/man3/wxDirDialog.*
#%{_libdir}/erlang/man/man3/wxDirPickerCtrl.*
#%{_libdir}/erlang/man/man3/wxDisplayChangedEvent.*
#%{_libdir}/erlang/man/man3/wxEraseEvent.*
#%{_libdir}/erlang/man/man3/wxEvent.*
#%{_libdir}/erlang/man/man3/wxEvtHandler.*
#%{_libdir}/erlang/man/man3/wxFileDataObject.*
#%{_libdir}/erlang/man/man3/wxFileDialog.*
#%{_libdir}/erlang/man/man3/wxFileDirPickerEvent.*
#%{_libdir}/erlang/man/man3/wxFilePickerCtrl.*
#%{_libdir}/erlang/man/man3/wxFindReplaceData.*
#%{_libdir}/erlang/man/man3/wxFindReplaceDialog.*
#%{_libdir}/erlang/man/man3/wxFlexGridSizer.*
#%{_libdir}/erlang/man/man3/wxFocusEvent.*
#%{_libdir}/erlang/man/man3/wxFont.*
#%{_libdir}/erlang/man/man3/wxFontData.*
#%{_libdir}/erlang/man/man3/wxFontDialog.*
#%{_libdir}/erlang/man/man3/wxFontPickerCtrl.*
#%{_libdir}/erlang/man/man3/wxFontPickerEvent.*
#%{_libdir}/erlang/man/man3/wxFrame.*
#%{_libdir}/erlang/man/man3/wxGauge.*
#%{_libdir}/erlang/man/man3/wxGBSizerItem.*
#%{_libdir}/erlang/man/man3/wxGenericDirCtrl.*
#%{_libdir}/erlang/man/man3/wxGLCanvas.*
#%{_libdir}/erlang/man/man3/wxGraphicsBrush.*
#%{_libdir}/erlang/man/man3/wxGraphicsContext.*
#%{_libdir}/erlang/man/man3/wxGraphicsFont.*
#%{_libdir}/erlang/man/man3/wxGraphicsMatrix.*
#%{_libdir}/erlang/man/man3/wxGraphicsObject.*
#%{_libdir}/erlang/man/man3/wxGraphicsPath.*
#%{_libdir}/erlang/man/man3/wxGraphicsPen.*
#%{_libdir}/erlang/man/man3/wxGraphicsRenderer.*
#%{_libdir}/erlang/man/man3/wxGrid.*
#%{_libdir}/erlang/man/man3/wxGridBagSizer.*
#%{_libdir}/erlang/man/man3/wxGridCellAttr.*
#%{_libdir}/erlang/man/man3/wxGridCellBoolEditor.*
#%{_libdir}/erlang/man/man3/wxGridCellBoolRenderer.*
#%{_libdir}/erlang/man/man3/wxGridCellChoiceEditor.*
#%{_libdir}/erlang/man/man3/wxGridCellEditor.*
#%{_libdir}/erlang/man/man3/wxGridCellFloatEditor.*
#%{_libdir}/erlang/man/man3/wxGridCellFloatRenderer.*
#%{_libdir}/erlang/man/man3/wxGridCellNumberEditor.*
#%{_libdir}/erlang/man/man3/wxGridCellNumberRenderer.*
#%{_libdir}/erlang/man/man3/wxGridCellRenderer.*
#%{_libdir}/erlang/man/man3/wxGridCellStringRenderer.*
#%{_libdir}/erlang/man/man3/wxGridCellTextEditor.*
#%{_libdir}/erlang/man/man3/wxGridEvent.*
#%{_libdir}/erlang/man/man3/wxGridSizer.*
#%{_libdir}/erlang/man/man3/wxHelpEvent.*
#%{_libdir}/erlang/man/man3/wxHtmlEasyPrinting.*
#%{_libdir}/erlang/man/man3/wxHtmlLinkEvent.*
#%{_libdir}/erlang/man/man3/wxHtmlWindow.*
#%{_libdir}/erlang/man/man3/wxIcon.*
#%{_libdir}/erlang/man/man3/wxIconBundle.*
#%{_libdir}/erlang/man/man3/wxIconizeEvent.*
#%{_libdir}/erlang/man/man3/wxIdleEvent.*
#%{_libdir}/erlang/man/man3/wxImage.*
#%{_libdir}/erlang/man/man3/wxImageList.*
#%{_libdir}/erlang/man/man3/wxInitDialogEvent.*
#%{_libdir}/erlang/man/man3/wxJoystickEvent.*
#%{_libdir}/erlang/man/man3/wxKeyEvent.*
#%{_libdir}/erlang/man/man3/wxLayoutAlgorithm.*
#%{_libdir}/erlang/man/man3/wxListbook.*
#%{_libdir}/erlang/man/man3/wxListBox.*
#%{_libdir}/erlang/man/man3/wxListCtrl.*
#%{_libdir}/erlang/man/man3/wxListEvent.*
#%{_libdir}/erlang/man/man3/wxListItem.*
#%{_libdir}/erlang/man/man3/wxListItemAttr.*
#%{_libdir}/erlang/man/man3/wxListView.*
#%{_libdir}/erlang/man/man3/wxLocale.*
#%{_libdir}/erlang/man/man3/wxLogNull.*
#%{_libdir}/erlang/man/man3/wxMask.*
#%{_libdir}/erlang/man/man3/wxMaximizeEvent.*
#%{_libdir}/erlang/man/man3/wxMDIChildFrame.*
#%{_libdir}/erlang/man/man3/wxMDIClientWindow.*
#%{_libdir}/erlang/man/man3/wxMDIParentFrame.*
#%{_libdir}/erlang/man/man3/wxMemoryDC.*
#%{_libdir}/erlang/man/man3/wxMenu.*
#%{_libdir}/erlang/man/man3/wxMenuBar.*
#%{_libdir}/erlang/man/man3/wxMenuEvent.*
#%{_libdir}/erlang/man/man3/wxMenuItem.*
#%{_libdir}/erlang/man/man3/wxMessageDialog.*
#%{_libdir}/erlang/man/man3/wxMiniFrame.*
#%{_libdir}/erlang/man/man3/wxMirrorDC.*
#%{_libdir}/erlang/man/man3/wxMouseCaptureChangedEvent.*
#%{_libdir}/erlang/man/man3/wxMouseCaptureLostEvent.*
#%{_libdir}/erlang/man/man3/wxMouseEvent.*
#%{_libdir}/erlang/man/man3/wxMoveEvent.*
#%{_libdir}/erlang/man/man3/wxMultiChoiceDialog.*
#%{_libdir}/erlang/man/man3/wxNavigationKeyEvent.*
#%{_libdir}/erlang/man/man3/wxNotebook.*
#%{_libdir}/erlang/man/man3/wxNotebookEvent.*
#%{_libdir}/erlang/man/man3/wxNotifyEvent.*
#%{_libdir}/erlang/man/man3/wxOverlay.*
#%{_libdir}/erlang/man/man3/wxPageSetupDialog.*
#%{_libdir}/erlang/man/man3/wxPageSetupDialogData.*
#%{_libdir}/erlang/man/man3/wxPaintDC.*
#%{_libdir}/erlang/man/man3/wxPaintEvent.*
#%{_libdir}/erlang/man/man3/wxPalette.*
#%{_libdir}/erlang/man/man3/wxPaletteChangedEvent.*
#%{_libdir}/erlang/man/man3/wxPanel.*
#%{_libdir}/erlang/man/man3/wxPasswordEntryDialog.*
#%{_libdir}/erlang/man/man3/wxPen.*
#%{_libdir}/erlang/man/man3/wxPickerBase.*
#%{_libdir}/erlang/man/man3/wxPopupTransientWindow.*
#%{_libdir}/erlang/man/man3/wxPopupWindow.*
#%{_libdir}/erlang/man/man3/wxPostScriptDC.*
#%{_libdir}/erlang/man/man3/wxPreviewCanvas.*
#%{_libdir}/erlang/man/man3/wxPreviewControlBar.*
#%{_libdir}/erlang/man/man3/wxPreviewFrame.*
#%{_libdir}/erlang/man/man3/wxPrintData.*
#%{_libdir}/erlang/man/man3/wxPrintDialog.*
#%{_libdir}/erlang/man/man3/wxPrintDialogData.*
#%{_libdir}/erlang/man/man3/wxPrinter.*
#%{_libdir}/erlang/man/man3/wxPrintout.*
#%{_libdir}/erlang/man/man3/wxPrintPreview.*
#%{_libdir}/erlang/man/man3/wxProgressDialog.*
#%{_libdir}/erlang/man/man3/wxQueryNewPaletteEvent.*
#%{_libdir}/erlang/man/man3/wxRadioBox.*
#%{_libdir}/erlang/man/man3/wxRadioButton.*
#%{_libdir}/erlang/man/man3/wxRegion.*
#%{_libdir}/erlang/man/man3/wxSashEvent.*
#%{_libdir}/erlang/man/man3/wxSashLayoutWindow.*
#%{_libdir}/erlang/man/man3/wxSashWindow.*
#%{_libdir}/erlang/man/man3/wxScreenDC.*
#%{_libdir}/erlang/man/man3/wxScrollBar.*
#%{_libdir}/erlang/man/man3/wxScrolledWindow.*
#%{_libdir}/erlang/man/man3/wxScrollEvent.*
#%{_libdir}/erlang/man/man3/wxScrollWinEvent.*
#%{_libdir}/erlang/man/man3/wxSetCursorEvent.*
#%{_libdir}/erlang/man/man3/wxShowEvent.*
#%{_libdir}/erlang/man/man3/wxSingleChoiceDialog.*
#%{_libdir}/erlang/man/man3/wxSizeEvent.*
#%{_libdir}/erlang/man/man3/wxSizer.*
#%{_libdir}/erlang/man/man3/wxSizerFlags.*
#%{_libdir}/erlang/man/man3/wxSizerItem.*
#%{_libdir}/erlang/man/man3/wxSlider.*
#%{_libdir}/erlang/man/man3/wxSpinButton.*
#%{_libdir}/erlang/man/man3/wxSpinCtrl.*
#%{_libdir}/erlang/man/man3/wxSpinEvent.*
#%{_libdir}/erlang/man/man3/wxSplashScreen.*
#%{_libdir}/erlang/man/man3/wxSplitterEvent.*
#%{_libdir}/erlang/man/man3/wxSplitterWindow.*
#%{_libdir}/erlang/man/man3/wxStaticBitmap.*
#%{_libdir}/erlang/man/man3/wxStaticBox.*
#%{_libdir}/erlang/man/man3/wxStaticBoxSizer.*
#%{_libdir}/erlang/man/man3/wxStaticLine.*
#%{_libdir}/erlang/man/man3/wxStaticText.*
#%{_libdir}/erlang/man/man3/wxStatusBar.*
#%{_libdir}/erlang/man/man3/wxStdDialogButtonSizer.*
#%{_libdir}/erlang/man/man3/wxStyledTextCtrl.*
#%{_libdir}/erlang/man/man3/wxStyledTextEvent.*
#%{_libdir}/erlang/man/man3/wxSysColourChangedEvent.*
#%{_libdir}/erlang/man/man3/wxSystemOptions.*
#%{_libdir}/erlang/man/man3/wxSystemSettings.*
#%{_libdir}/erlang/man/man3/wxTaskBarIcon.*
#%{_libdir}/erlang/man/man3/wxTaskBarIconEvent.*
#%{_libdir}/erlang/man/man3/wxTextAttr.*
#%{_libdir}/erlang/man/man3/wxTextCtrl.*
#%{_libdir}/erlang/man/man3/wxTextDataObject.*
#%{_libdir}/erlang/man/man3/wxTextEntryDialog.*
#%{_libdir}/erlang/man/man3/wxToggleButton.*
#%{_libdir}/erlang/man/man3/wxToolBar.*
#%{_libdir}/erlang/man/man3/wxToolbook.*
#%{_libdir}/erlang/man/man3/wxToolTip.*
#%{_libdir}/erlang/man/man3/wxTopLevelWindow.*
#%{_libdir}/erlang/man/man3/wxTreebook.*
#%{_libdir}/erlang/man/man3/wxTreeCtrl.*
#%{_libdir}/erlang/man/man3/wxTreeEvent.*
#%{_libdir}/erlang/man/man3/wxUpdateUIEvent.*
#%{_libdir}/erlang/man/man3/wxWindow.*
#%{_libdir}/erlang/man/man3/wxWindowCreateEvent.*
#%{_libdir}/erlang/man/man3/wxWindowDC.*
#%{_libdir}/erlang/man/man3/wxWindowDestroyEvent.*
#%{_libdir}/erlang/man/man3/wxXmlResource.*
#%endif
%endif %{__with_wxwidgets}

%files xmerl
%{_libdir}/erlang/lib/xmerl-*/
%if %{withdoc}
%{_libdir}/erlang/man/man3/xmerl.*
%{_libdir}/erlang/man/man3/xmerl_eventp.*
%{_libdir}/erlang/man/man3/xmerl_sax_parser.*
%{_libdir}/erlang/man/man3/xmerl_scan.*
%{_libdir}/erlang/man/man3/xmerl_xpath.*
%{_libdir}/erlang/man/man3/xmerl_xs.*
%{_libdir}/erlang/man/man3/xmerl_xsd.*
%endif


%changelog
* Fri Feb 10 2017 Tony Reix <tony.reix@atos.net> - 19.2-3
- Hipe + SMP + Threads.

* Fri Jan 23 2017 Tony Reix <tony.reix@atos.net> - 19.2-2
- Still patches. No Hipe. No SMP. No Threads. No Java.

* Fri Jan 06 2017 Tony Reix <tony.reix@atos.net> - 19.2-1
- First port on AIX 6.1

* Wed Nov 23 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.1.6-2
- Fix HiPE by disabling -fpie
- Fix dialyzer generation

* Wed Nov  9 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.1.6-1
- Ver. 19.1.6

* Mon Nov  7 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.1.5-1
- Ver. 19.1.5

* Fri Oct 14 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.1.4-1
- Ver. 19.1.4

* Tue Oct 11 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.1.3-1
- Ver. 19.1.3

* Thu Oct  6 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.1.2-1
- Ver. 19.1.2

* Tue Oct  4 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.1.1-1
- Ver. 19.1.1

* Wed Sep 14 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.0.7-1
- Ver. 19.0.7

* Wed Sep 14 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.0.6-1
- Ver. 19.0.6

* Tue Aug 23 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.0.5-1
- Ver. 19.0.5

* Tue Aug 16 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.0.4-1
- Ver. 19.0.4

* Fri Aug 12 2016 Michal Toman <mtoman@fedoraproject.org> - 19.0.2-2
- Disable doc on MIPS

* Wed Jul 27 2016 Peter Lemenkov <lemenkov@gmail.com> - 19.0.2-1
- Ver. 19.0.2
- The following packages were removed - ose, test_server (merged into common_test), webtool
- Merge (x)emacs subpackages into erlang-typer

* Tue Jul 26 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.3.4.2-1
- Ver. 18.3.4.2

* Fri Jul 15 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.3.4.1-1
- Ver. 18.3.4.1
- Allow node registration via IPv6 (PR erlang/otp#1129)

* Tue Jun 14 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.3.4-1
- Ver. 18.3.4

* Mon Jun 13 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.3.3-2
- Fix regression with GCC 6.x.y

* Wed May 11 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.3.3-1
- Ver. 18.3.3

* Wed Apr 27 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.3.2-1
- Ver. 18.3.2

* Sun Apr 10 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.3.1-2
- Enable selective building

* Thu Apr  7 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.3.1-1
- Ver. 18.3.1

* Thu Mar 31 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.3-2
- Added patch to suppress sending systemd notifications from epmd if not
  started as a systemd service.

* Thu Mar 24 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.3-1
- Ver. 18.3

* Sun Feb 28 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.2.4-2
- Fixed issue with nodes registration over IPv6

* Tue Feb 23 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.2.4-1
- Ver. 18.2.4
- Build against wxGTK-3.x.y as recommended by upstream. This change won't
  affect "headless" installations.

* Fri Feb 19 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.2.3-3
- Add missing dependency

* Wed Feb 10 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.2.3-2
- Workaround for broken cmpxchg8b inlining on ix86 (rhbz#1240487)
- Don't use generic optimization on ix86
- Increase memory up to 1024 mbytes while generating docs on non-ppc arches

* Tue Feb  9 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.2.3-1
- Ver. 18.2.3

* Wed Feb 03 2016 Fedora Release Engineering <releng@fedoraproject.org> - 18.2.2-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_24_Mass_Rebuild

* Fri Jan 22 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.2.2-3
- Disable optimizations for Intel Atom CPU on ix86 arches

* Sun Jan 17 2016 John Eckersberg <eck@redhat.com> - 18.2.2-2
- Add patch for epmd ipv6 support (rhbz#1299253)

* Mon Jan 11 2016 Peter Lemenkov <lemenkov@gmail.com> - 18.2.2-1
- Ver. 18.2.2

* Tue Aug 18 2015 John Eckersberg <eck@redhat.com> - 17.4-5
- Disable docs by default on ARM until I figure out why fop hangs

* Wed Aug  5 2015 John Eckersberg <eck@redhat.com> - 17.4-4
- Add patch for CVE-2015-2774 - TLS-1.0 POODLE vulnerability (rhbz#1206712)

* Wed Jun 17 2015 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 17.4-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_23_Mass_Rebuild

* Sat May 02 2015 Kalev Lember <kalevlember@gmail.com> - 17.4-2
- Rebuilt for GCC 5 C++11 ABI change

* Fri Dec 12 2014 Peter Lemenkov <lemenkov@gmail.com> - 17.4-1
- Ver. 17.4

* Mon Dec 01 2014 Peter Lemenkov <lemenkov@gmail.com> - 17.3.4-3
- Disable SSLv3 (see rhbz #1169375)

* Mon Dec 01 2014 Peter Lemenkov <lemenkov@gmail.com> - 17.3.4-2
- Backport useful os:getenv/2 from master (see https://github.com/erlang/otp/pull/535 )

* Sat Nov 08 2014 Peter Lemenkov <lemenkov@gmail.com> - 17.3.4-1
- Ver. 17.3.4 (API/ABI compatible release)
- Relax an erlang-tools dependency on erlang-webtool down to Suggests

* Sun Nov 02 2014 Peter Lemenkov <lemenkov@gmail.com> - 17.3.3-1
- Ver. 17.3.3

* Sun Sep  7 2014 Peter Lemenkov <lemenkov@gmail.com> - 17.2.2-1
- Ver. 17.2.2
- Fixed a race which could make create_table fail if a node was going down
  during the transaction. See upstream issue OTP-12124 for a further reference.

* Tue Aug 26 2014 Peter Lemenkov <lemenkov@gmail.com> - 17.2.1-1
- Ver. 17.2.1
- Removed support for EPEL5
- The following packages were removed - appmon, pman, toolbar, tv
- The following packages were added - ose
- No longer using a pre-built doc-files
- Erlang no longer requires erlang-examples subpackage (see rhbz #1038314)

* Sat Aug 16 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - R16B-03.7.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_22_Mass_Rebuild

* Wed Jun 11 2014 Peter Lemenkov <lemenkov@gmail.com> - R16B-03.7
- Added missing template for epmd@.socket

* Fri Jun 06 2014 Peter Lemenkov <lemenkov@gmail.com> - R16B-03.6
- Add configurable EPMD socket unit
- Change EPMD service's type from simple to notify

* Wed Apr 02 2014 Peter Lemenkov <lemenkov@gmail.com> - R16B-03.5
- Improve EPMD service

* Fri Mar 28 2014 Peter Lemenkov <lemenkov@gmail.com> - R16B-03.4
- Create group and user for EPMD

* Thu Mar 27 2014 Peter Lemenkov <lemenkov@gmail.com> - R16B-03.3
- Ver. R16B03-1 (Bugfix release)
- Enabled systemd support in EPMD

* Fri Feb 7 2014 Sam Kottler <skottler@fedoraproject.org> - R16B-03.2
- Fix macro usage for EPEL7 build and added need_bootstrap

* Tue Dec 24 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-03.1
- Ver. R16B03

* Tue Oct 29 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-02.7
- Really disable HiPE on s390(x)

* Tue Oct 29 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-02.6
- Actually re-enable HiPE

* Mon Oct 28 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-02.5
- Re-enable HiPE on ppc64, ppc64v7

* Mon Oct 28 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-02.4
- Disable HiPE on s390(x) (rhbz #1023960)
- Fix HiPE on ppc (rhbz #1023960)

* Thu Oct 24 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-02.3
- TEMPORARILY disable ECC until dust settles

* Thu Oct 24 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-02.2
- Fix building for armv7hl (patch taken from OpenSUSE repository)

* Thu Sep 26 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-02.1
- Ver. R16B02 (see rhbz #1009502)
- Increase erlang(erl_drv_version) from 2.1 to 2.2 (drivers needs rebuilding)
- Remove ancient obsoletes (see rhbz #1002103)
- Removed pre-F18 compatibility
- Enable HiPE

* Sat Aug 03 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - R16B-01.1.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_20_Mass_Rebuild

* Wed Jun 19 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-01.1
- Ver. R16B01
- Added graphviz as a requirement for dialyzer (thanks to Matwey V. Kornilov)

* Mon Mar 11 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-0.4
- Add Requires for SCTP (dlopened library)

* Sat Mar 02 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-0.3
- Add neccessary BuildRequires for SCTP

* Sat Mar 02 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-0.2
- Fixed erts provides

* Thu Feb 28 2013 Peter Lemenkov <lemenkov@gmail.com> - R16B-0.1
- Ver. R16B
- Enabled SCTP (see rhbz #908530)

* Sun Feb 03 2013 Peter Lemenkov <lemenkov@gmail.com> - R16A-0.1
- Ver. R16A

* Tue Dec 25 2012 Peter Lemenkov <lemenkov@gmail.com> - R15B-03.2
- Run make clean before build (to remove pre-built files)

* Fri Dec 21 2012 Peter Lemenkov <lemenkov@gmail.com> - R15B-03.1
- Ver. R15B03 (actually R15B03-1)

* Mon Sep 10 2012 Peter Lemenkov <lemenkov@gmail.com> - R15B-02.1
- Ver. R15B02

* Wed Aug 15 2012 Karsten Hopp <karsten@redhat.com> R15B-01.4.2
- set BASE_OPTIONS to -Xmx1536m on ppc*

* Wed Jul 18 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - R15B-01.4.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_18_Mass_Rebuild

* Tue Jun 26 2012 Peter Lemenkov <lemenkov@gmail.com> - R15B-01.3
- Return back erl_interface' private API headers (rhbz #818419)

* Fri Jun 15 2012 Dan Horák <dan[at]danny.cz - R15B-01.3
- resolve OOM condition when generating docs

* Mon May 07 2012 Peter Lemenkov <lemenkov@gmail.com> - R15B-01.2
- Fixed examples packaging

* Mon May 07 2012 Peter Lemenkov <lemenkov@gmail.com> - R15B-01.1
- Ver. R15B01
- New sub-package - eldap

* Tue Feb 07 2012 Peter Lemenkov <lemenkov@gmail.com> - R15B-00.1
- Ver. R15B

* Fri Jan 13 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - R14B-04.1.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_17_Mass_Rebuild

* Sun Aug 07 2011 Peter Lemenkov <lemenkov@gmail.com> - R14B-04.1
- Ver. R14B04

* Sun Aug 07 2011 Peter Lemenkov <lemenkov@gmail.com> - R14B-03.3
- Use prebuilt docs on EL-[56] also

* Thu Jul 21 2011 Peter Lemenkov <lemenkov@gmail.com> - R14B-03.2
- Fixed building on F-15

* Wed Jul 20 2011 Peter Lemenkov <lemenkov@gmail.com> - R14B-03.1
- Ver. R14B03
- New module - diameter
- Several new examples directories

* Fri Apr  1 2011 Hans Ulrich Niedermann <hun@n-dimensional.de> - R14B-02.2
- Work around fop-1.0-14.fc16 bug (#689930) by using prebuilt docs for f16/rawhide

* Mon Mar 21 2011 Hans Ulrich Niedermann <hun@n-dimensional.de> - R14B-02.1
- snmp-4.19 (R14B02) ships lib/snmp/bin/snmpc
- inets-5.5.2 puts *.hrl in include/
- install/symlink *.jar into %%{_javadir} (#679031)
- Update to upstream maintenance release R14B02

* Sat Feb 12 2011 Hans Ulrich Niedermann <hun@n-dimensional.de> - R14B-01.5
- erlang-doc does not really require erlang base package (#629723)
- Add %%{?_isa} for all explicit "Requires:"

* Tue Feb 08 2011 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - R14B-01.4.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_15_Mass_Rebuild

* Mon Jan 31 2011 Hans Ulrich Niedermann <hun@n-dimensional.de> - R14B-01.4
- Adapt %%files: Add wxSystemSettings.3 man page
- Adapt %%files for change from run_test to ct_run
- Remove rpaths from lib/ssl-*/bin/esock_ssl
- Update erlang.spec and otp-00*.patch without numbers
- otp-get-patches.sh: Remove patch numbering

* Sun Jan 30 2011 Hans Ulrich Niedermann <hun@n-dimensional.de> - R14B-01.3
- Add "buffer overflow during build" fix (#663260)

* Wed Dec 15 2010 Hans Ulrich Niedermann <hun@n-dimensional.de> - R14B-01.2
- Update to rebased patches

* Mon Dec 13 2010 Hans Ulrich Niedermann <hun@n-dimensional.de> - R14B-01.1
- Update to upstream release R14B01 (the patches still need work)

* Thu Nov 18 2010 Peter Lemenkov <lemenkov@gmail.com> - R14B-0.5
- Fixed building on EL-6

* Mon Nov 15 2010 Peter Lemenkov <lemenkov@gmail.com> - R14B-0.4
- No more dependent on erlang-rpm-macros sub-package

* Thu Nov 11 2010 Peter Lemenkov <lemenkov@gmail.com> - R14B-0.3
- Remove pre-built stuff

* Fri Nov  5 2010 Peter Lemenkov <lemenkov@gmail.com> - R14B-0.2
- Fixed doc-files and man-pages instalation for EL-5
- Temporarily (I hope) disabled emacs-related stuff in EL-5
- Disable erlang-rpm-macros subpackage for EL-5

* Wed Sep 29 2010 jkeating - R14B-0.1.1
- Rebuilt for gcc bug 634757

* Thu Sep 16 2010 Peter Lemenkov <lemenkov@gmail.com> - R14B-0.1
- R14B release

* Mon Aug  2 2010 Hans Ulrich Niedermann <hun@n-dimensional.de> - R14A-0.6
- Implement '--without doc' conditional for faster test builds (#618245).

* Fri Jul 30 2010 Hans Ulrich Niedermann <hun@n-dimensional.de> - R14A-0.5
- Properly hook up (X)Emacs erlang-mode (#491165)

* Mon Jul 26 2010 Hans Ulrich Niedermann <hun@n-dimensional.de> - R14A-0.4
- Spec file cleanups:
  - Avoid accidental %%rel increments by rpmdev-bumpspec.
  - Use %%global for our spec file macros.
  - Use macro for redundant directory names.
  - Whitespace cleanups (tabs vs. spaces).
  - Fix accidental macro usage in %%changelog.

* Wed Jul 14 2010 Dan Horák <dan@danny.cz> - R14A-0.3
- rebuilt against wxGTK-2.8.11-2

* Sat Jun 26 2010 Peter Lemenkov <lemenkov@gmail.com> - R14A-0.2
- Updated list of explicit requirements

* Fri Jun 18 2010 Peter Lemenkov <lemenkov@gmail.com> - R14A-0.1
- R14A release

* Sat May 15 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.12
- Moved dialyzer and typer executables from erts to appropriate rpms

* Fri May 14 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.11
- Do not mention nteventlog in os_mon.app, see rhbz #592251

* Thu May  6 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.10
- Disabled automatic requires/provides generation

* Wed Apr 28 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.9
- Added missing files, necessary for emacs (see rhbz #585349)
- Patches rebased

* Tue Apr 27 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.8
- Added missing BuildRequires libxslt (for building docs)
- Removed %%post script completely (resolves rhbz #586428)
- Since now both docs and man-pages are built from sources
- No need to manually create symlinks in %%{_bindir}

* Mon Apr 26 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.7
- Build with erlang-rpm-macros
- Man-files are packed with packages, they belong to

* Mon Apr 26 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.6
- Made erlang-rpm-macros as separate package
- Fix error while installing erlang-rpm-macros

* Sat Apr 17 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.5
- Use erlang rpm macros for adding provides/reqires
- All %%{_libdir}/erlang/lib/* items were splitted off from main package, which
  in turn becomes purely virtual now.
- Removing RPM_BUILD_ROOT from several installed files is no longer required

* Sat Apr 17 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.4
- Added missing Requires mesa-libGL{U} for wx module (rhbz #583287)
- Fix for buffer overflow in pcre module (rhbz #583288)
- Doc sub-package marked as noarch (partially resolves rhbz #491165)

* Fri Mar 26 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.3
- Added rpm-related stuff for auto-generating erlang dependencies in the future builds
- Since now *.yrl files are removed too.
- Removed unnecessary C and Java sources

* Fri Mar 26 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.2
- Do not remove all files from %%{_libdir}/erlang/lib/*/src - keep
  *.[yh]rl intact
- Fix permissions for megaco *.so objects
- Fix permissions for asn1 *.so objects

* Sat Feb 13 2010 Peter Lemenkov <lemenkov@gmail.com> - R13B-04.1
- New release R13B-04
- Since now we're using %%configure instead of ./configure
- Removed no longer needed fix for newer glibc version
- Dropped %%patch3 (applied upstream)
- Rebased patches
- Added BR fop for rebuilding of docs
- Use system-wide zlib instead of shipped one
- Dropped BR gd-devel
- Removed unneeded sources (should be fixed upstream)
- Fixed permission for wx driver (should be fixed upstream)

* Thu Oct 22 2009 Lubomir Rintel (Good Data) <lubo.rintel@gooddata.com> - R13B-02-1
- Update to R13B-02 (patched for what's released as 02-1 by upstream)

* Tue Aug 25 2009 Tomas Mraz <tmraz@redhat.com> - R13B-01.2
- rebuilt with new openssl

* Mon Aug 10 2009 Gerard Milmeister <gemi@bluewin.ch> - R13B-01.1
- update to R13B01

* Fri Jul 24 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - R12B-6.7
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

* Tue Apr 21 2009 Debarshi Ray <rishi@fedoraproject.org> R12B-5.7
- Updated rpath patch.
- Fixed configure to respect $RPM_OPT_FLAGS.

* Sun Mar  1 2009 Gerard Milmeister <gemi@bluewin.ch> - R12B-5.6
- new release R12B-5
- link escript and dialyzer to %%{_bindir}

* Tue Feb 24 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - R12B-5.5
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

* Sat Feb 14 2009 Dennis Gilmore <dennis@ausil.us> - R12B-4.5
- fix sparc arches to compile

* Fri Jan 16 2009 Tomas Mraz <tmraz@redhat.com> - R12B-4.4
- rebuild with new openssl

* Sat Oct 25 2008 Gerard Milmeister <gemi@bluewin.ch> - R12B-4.1
- new release R12B-4

* Fri Sep  5 2008 Gerard Milmeister <gemi@bluewin.ch> - R12B-3.3
- fixed sslrpath patch

* Thu Jul 17 2008 Tom "spot" Callaway <tcallawa@redhat.com> - R12B-3.2
- fix license tag

* Sun Jul  6 2008 Gerard Milmeister <gemi@bluewin.ch> - R12B-3.1
- new release R12B-3

* Thu Mar 27 2008 Gerard Milmeister <gemi@bluewin.ch> - R12B-1.1
- new release R12B-1

* Sat Feb 23 2008 Gerard Milmeister <gemi@bluewin.ch> - R12B-0.3
- disable strict aliasing optimization

* Mon Feb 18 2008 Fedora Release Engineering <rel-eng@fedoraproject.org> - R12B-0.2
- Autorebuild for GCC 4.3

* Sat Dec  8 2007 Gerard Milmeister <gemi@bluewin.ch> - R12B-0.1
- new release R12B-0

* Wed Dec 05 2007 Release Engineering <rel-eng at fedoraproject dot org> - R11B-6
 - Rebuild for deps

* Sun Aug 19 2007 Gerard Milmeister <gemi@bluewin.ch> - R11B-5.3
- fix some permissions

* Sat Aug 18 2007 Gerard Milmeister <gemi@bluewin.ch> - R11B-5.2
- enable dynamic linking for ssl

* Sat Aug 18 2007 Gerard Milmeister <gemi@bluewin.ch> - R11B-5.1
- new release R11B-5

* Sat Mar 24 2007 Thomas Fitzsimmons <fitzsim@redhat.com> - R11B-2.4
- Require java-1.5.0-gcj-devel for build.

* Sun Dec 31 2006 Gerard Milmeister <gemi@bluewin.ch> - R11B-2.3
- remove buildroot from installed files

* Sat Dec 30 2006 Gerard Milmeister <gemi@bluewin.ch> - R11B-2.2
- added patch for compiling with glibc 2.5

* Sat Dec 30 2006 Gerard Milmeister <gemi@bluewin.ch> - R11B-2.1
- new version R11B-2

* Mon Aug 28 2006 Gerard Milmeister <gemi@bluewin.ch> - R11B-0.3
- Rebuild for FE6

* Wed Jul  5 2006 Gerard Milmeister <gemi@bluewin.ch> - R11B-0.2
- add BR m4

* Thu May 18 2006 Gerard Milmeister <gemi@bluewin.ch> - R11B-0.1
- new version R11B-0

* Wed May  3 2006 Gerard Milmeister <gemi@bluewin.ch> - R10B-10.3
- added patch for run_erl by Knut-Håvard Aksnes

* Mon Mar 13 2006 Gerard Milmeister <gemi@bluewin.ch> - R10B-10.1
- new version R10B-10

* Thu Dec 29 2005 Gerard Milmeister <gemi@bluewin.ch> - R10B-9.1
- New Version R10B-9

* Sat Oct 29 2005 Gerard Milmeister <gemi@bluewin.ch> - R10B-8.2
- updated rpath patch

* Sat Oct 29 2005 Gerard Milmeister <gemi@bluewin.ch> - R10B-8.1
- New Version R10B-8

* Sat Oct  1 2005 Gerard Milmeister <gemi@bluewin.ch> - R10B-6.4
- Added tk-devel and tcl-devel to buildreq
- Added tk to req

* Tue Sep  6 2005 Gerard Milmeister <gemi@bluewin.ch> - R10B-6.3
- Remove perl BuildRequires

* Tue Aug 30 2005 Gerard Milmeister <gemi@bluewin.ch> - R10B-6.2
- change /usr/lib to %%{_libdir}
- redirect output in %%post to /dev/null
- add unixODBC-devel to BuildRequires
- split doc off to erlang-doc package

* Sat Jun 25 2005 Gerard Milmeister <gemi@bluewin.ch> - R10B-6.1
- New Version R10B-6

* Sun Feb 13 2005 Gerard Milmeister <gemi@bluewin.ch> - R10B-3.1
- New Version R10B-3

* Mon Dec 27 2004 Gerard Milmeister <gemi@bluewin.ch> - 0:R10B-2-0.fdr.1
- New Version R10B-2

* Wed Oct  6 2004 Gerard Milmeister <gemi@bluewin.ch> - 0:R10B-0.fdr.1
- New Version R10B

* Thu Oct 16 2003 Gerard Milmeister <gemi@bluewin.ch> - 0:R9B-1.fdr.1
- First Fedora release
