!/bin/ksh

export MAJ=19
export MIN=3
export mini=1
export VERS=$MAJ.$MIN
echo PID=$$


# PATH=/opt/freeware/src/packages/BUILD/otp_src_19.3//bin:/usr/local/bin/:/opt/freeware/bin:/usr/linux/bin:/usr/local/bin:/usr/bin:/etc:/usr/sbin:/usr/ucb:/usr/bin/X11:/sbin:/usr/java8_64/jre/bin:/usr/java8_64/bin:/usr/samples/kernel:.:/usr/opt/ifor/ls/os/aix/bin

export ERL_TOP=$BUILD/otp_src_"$VERS"
cd $ERL_TOP || exit 1;
## Environnement de build

export PATH=$PWD/bin:/usr/local/bin/:/opt/freeware/bin:/usr/linux/bin:/usr/local/bin:/usr/bin:/etc:/usr/sbin:/usr/ucb:/usr/bin/X11:/sbin:/usr/java8_64/jre/bin:/usr/java8_64/bin

RPM_SOURCE_DIR="$SOURCES"
RPM_BUILD_DIR="$BUILD"
RPM_OPT_FLAGS="-O2 -fsigned-char"
RPM_ARCH="ppc"
RPM_OS="aix"
export RPM_SOURCE_DIR RPM_BUILD_DIR RPM_OPT_FLAGS RPM_ARCH RPM_OS
RPM_DOC_DIR="/opt/freeware/doc"
export RPM_DOC_DIR
RPM_PACKAGE_NAME="erlang"
RPM_PACKAGE_VERSION="$VERS"
RPM_PACKAGE_RELEASE=$mini
export RPM_PACKAGE_NAME RPM_PACKAGE_VERSION RPM_PACKAGE_RELEASE
LIBPATH="/opt/freeware/lib"

umask 022

export RM="/usr/bin/rm -f"
export AR="/usr/bin/ar"
export NM="/usr/bin/nm -X32_64"

export CC="/opt/freeware/bin/gcc"
export CXX="/opt/freeware/bin/g++"
export LDFLAGS="-L/opt/freeware/lib"
export FLAGS="-maix32"

# Set up proper cflags/cxxflags first
ERL_FLAGS="${RPM_OPT_FLAGS} -fno-strict-aliasing -D_LINUX_SOURCE_COMPAT"

CFLAGS="${ERL_FLAGS} -maix32" CXXFLAGS="${ERL_FLAGS} -maix32"
CFLAGS="${CFLAGS:--O2 -fsigned-char}" ; export CFLAGS ;
CXXFLAGS="${CXXFLAGS:--O2 -fsigned-char}" ; export CXXFLAGS ;
FFLAGS="${FFLAGS:--O2 -fsigned-char}" ; export FFLAGS ;

unset AIX64
unset AIX32
AIX32=true


export TESTROOT=$ERL_TOP/release/tests/



## Environnement du programme lance_reste_tests



export REPTEST=release/tests


export LIBPATH="/opt/freeware/lib"

export ERL_PATH="$ERL_TOP/$REPTEST/$TEST:$ERL_TOP/bin/powerpc-ibm-aix6.1:$ERL_TOP/bin:/usr/local/bin/:/opt/freeware/bin:/usr/linux/bin:/usr/local/bin:/usr/bin:/etc:/usr/sbin:/usr/ucb:/usr/bin/X11:/sbin:/usr/java5/jre/bin:/usr/java5/bin:/usr/samples/kernel:/usr/java131/jre/bin:/usr/java131/bin:/usr/java14/jre/bin:/usr/java14/bin:."

fonct_lance()
{
    #    echo "\nLancement de la suite de tezsts : REpertoire:$1 test:$2\n"

    TEST=$1"_test"
    CRASH_DUMP=$2"_erl_crash.dump"
    REP=$3
    SPEC=$4
    set -x

    echo -eval "ts_run:ct_run_test(\"/home2/freeware/src/packages/BUILD/otp_src_"$VERS"/release/tests/$TEST\", [{abort_if_missing_suites,true},{spec,[\"$SPEC.spec\"]},{allow_user_terms,true},{logdir,\"../test_server\"},{config,[\"../test_server/ts.config\",\"../test_server/ts.unix.config\"]},{vars,[{verbose,0}]},batch,{scale_timetraps,true}])"

    erl -sname test_server -rsh rsh -env PATH "$ERL_PATH" -env ERL_CRASH_DUMP $ERL_TOP/$REPTEST/test_server/$CRASH_DUMP -boot start_sasl -sasl errlog_type error -pz "$ERL_TOP/$REPTEST/test_server" -ct_test_vars "{net_dir,\"\"}" -eval "ts_run:ct_run_test(\"/home2/freeware/src/packages/BUILD/otp_src_"$VERS"/release/tests/$TEST\", [{abort_if_missing_suites,true},{spec,[\"$SPEC.spec\"]},{allow_user_terms,true},{logdir,\"../test_server\"},{config,[\"../test_server/ts.config\",\"../test_server/ts.unix.config\"]},{vars,[{verbose,0}]},batch,{scale_timetraps,true}])"  -noinput -eval "erlang:halt(0,[{flush,false}])."

}

cd release/tests/test_server
#ERL_TOP/bin/erl -s ts install -s ts smoke_test batch -s init stop

DAT=$(date +%d_%H:%M:%S).log

$ERL_TOP/bin/erl -pa $TESTROOT/test_server -s ts install          -s init stop 2>&1 |tee traces_test_server.ts_install.$DAT.log

$ERL_TOP/bin/erl -pa $TESTROOT/test_server -s ts smoke_test batch -s init stop 2>&1 |tee traces_test_server.ts_smoke_test_batch.$DAT.log

# 46 applications de tests
export LISTE="
diameter:diameter:diameter:diameter
erl_interface:erl_interface:erl_interface:erl_interface
erl_interface:erl_interface:erl_interface:erl_interface_smoke
erl_docgen:erl_docgen:erl_docgen:erl_docgen
eunit:eunit:eunit:eunit
gs:gs:gs:gs
hipe:hipe:hipe:hipe
cosProperty:cosProperty:cosProperty:cosProperty
odbc:odbc:odbc:odbc
cosFileTransfer:cosFileTransfer:cosFileTransfer:cosFileTransfer
edoc:edoc:edoc:edoc
ic:ic:ic:ic_smoke
parsetools:parsetools:parsetools:parsetools
percept:percept:percept:percept
eldap:eldap:eldap:eldap
os_mon:os_mon:os_mon:os_mon_smoke
crypto:crypto:crypto:crypto
cosEventDomain:cosEventDomain:cosEventDomain:cosEventDomain
syntax_tools:syntax_tools:syntax_tools:syntax_tools
system:system:system:system_smoke
kernel:kernel:kernel:kernel_smoke
cosEvent:cosEvent:cosEvent:cosEvent
cosTransactions:cosTransactions:cosTransactions:cosTransactions
tools:tools:tools:tools
cosTime:cosTime:cosTime:cosTime
runtime_tools:runtime_tools:runtime_tools:runtime_tools
system:system:system:system
emulator:emulator:emulator:emulator_smoke
os_mon:os_mon:os_mon:os_mon
public_key:public_key:public_key:public_key
sasl:sasl:sasl:sasl
inets:inets:inets:inets
epmd:epmd:epmd:epmd
compiler:compiler:compiler:compiler
xmerl:xmerl:xmerl:xmerl
orber:orber:orber:orber
cosNotification:cosNotification:cosNotification:cosNotification
asn1:asn1:asn1:asn1
mnesia:mnesia:mnesia:mnesia
ssh:ssh:ssh:ssh
stdlib:stdlib:stdlib:stdlib
ic:ic:ic:ic
kernel:kernel:kernel:kernel
ssl:ssl:ssl:ssl
snmp:snmp:snmp:snmp
emulator:emulator:emulator:emulator
"




for LIGNE in $LISTE;
do
    P1=$(echo $LIGNE|awk -F: '{print $1}')
    P2=$(echo $LIGNE|awk -F: '{print $2}')
    P3=$(echo $LIGNE|awk -F: '{print $3}')
    P4=$(echo $LIGNE|awk -F: '{print $4}')
    LOG=traces.lance_all_tests.$P1.$P2.$P3.$P4.??_??:??:??.log
    [ -e $LOG ] && {
	echo SKIP fonct_lance  $P1  $P2  $P3  $P4
	continue;
    }
    
    LOG=traces.lance_all_tests.$P1.$P2.$P3.$P4.$(date +%d_%H:%M:%S).log

    echo fonct_lance  $P1  $P2  $P3  $P4
    date_deb=$(date +%s)
    fonct_lance  $P1  $P2  $P3  $P4   2>&1 | tee $LOG
    date_fin=$(date +%s)
    let duree_sec=$date_fin-$date_deb;
    echo Duree:$duree_sec "   " fonct_lance  $P1  $P2  $P3  $P4
    
done



